/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot.network;

import com.dremixam.leonlerobot.LeonLeRobotEntity;
import com.dremixam.leonlerobot.config.ConfigManager;
import com.dremixam.leonlerobot.network.NetworkConstants;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class NetworkHandler {
    private static ConfigManager configManager;

    public static void initialize(ConfigManager configManager) {
        NetworkHandler.configManager = configManager;
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_CLIENT_ENABLED, NetworkHandler::handleLeonClientEnabled);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_CLIENT_DISABLED, NetworkHandler::handleLeonClientDisabled);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_SPEAKING_START, NetworkHandler::handleLeonSpeakingStart);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_SPEAKING_STOP, NetworkHandler::handleLeonSpeakingStop);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_MOOD_NEUTRAL, NetworkHandler::handleLeonMoodNeutral);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_MOOD_UPSET, NetworkHandler::handleLeonMoodUpset);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_MOOD_ANGRY, NetworkHandler::handleLeonMoodAngry);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_MOOD_HAPPY, NetworkHandler::handleLeonMoodHappy);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_MOOD_SAD, NetworkHandler::handleLeonMoodSad);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_MOOD_LOVE, NetworkHandler::handleLeonMoodLove);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkConstants.LEON_MOOD_HORNY, NetworkHandler::handleLeonMoodHorny);
    }

    private static boolean isAuthorizedPlayer(class_1657 player) {
        String favoritePlayer = configManager.getFavoritePlayerName();
        return player.method_5477().getString().equals(favoritePlayer);
    }

    private static void handleLeonClientEnabled(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        if (!NetworkHandler.isAuthorizedPlayer((class_1657)player)) {
            return;
        }
        server.execute(() -> {
            LeonLeRobotEntity leon = LeonLeRobotEntity.getInstance();
            if (leon != null) {
                leon.setStreamControlled(true);
            }
        });
    }

    private static void handleLeonClientDisabled(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        if (!NetworkHandler.isAuthorizedPlayer((class_1657)player)) {
            return;
        }
        server.execute(() -> {
            LeonLeRobotEntity leon = LeonLeRobotEntity.getInstance();
            if (leon != null) {
                leon.setStreamControlled(false);
                leon.setStreamSpeaking(false);
            }
        });
    }

    private static void handleLeonSpeakingStart(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        if (!NetworkHandler.isAuthorizedPlayer((class_1657)player)) {
            System.err.println("[NetworkHandler] Paquet LEON_SPEAKING_START ignor\u00e9 - joueur non autoris\u00e9: " + player.method_5477().getString());
            return;
        }
        server.execute(() -> {
            LeonLeRobotEntity leon = LeonLeRobotEntity.getInstance();
            if (leon != null && leon.isStreamControlled()) {
                leon.setStreamSpeaking(true);
            }
        });
    }

    private static void handleLeonSpeakingStop(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        if (!NetworkHandler.isAuthorizedPlayer((class_1657)player)) {
            return;
        }
        server.execute(() -> {
            LeonLeRobotEntity leon = LeonLeRobotEntity.getInstance();
            if (leon != null && leon.isStreamControlled()) {
                leon.setStreamSpeaking(false);
            }
        });
    }

    private static void handleLeonMoodNeutral(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        NetworkHandler.handleMoodChange(server, player, LeonLeRobotEntity.Mood.NEUTRAL);
    }

    private static void handleLeonMoodUpset(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        NetworkHandler.handleMoodChange(server, player, LeonLeRobotEntity.Mood.UPSET);
    }

    private static void handleLeonMoodAngry(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        NetworkHandler.handleMoodChange(server, player, LeonLeRobotEntity.Mood.ANGRY);
    }

    private static void handleLeonMoodHappy(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        NetworkHandler.handleMoodChange(server, player, LeonLeRobotEntity.Mood.HAPPY);
    }

    private static void handleLeonMoodSad(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        NetworkHandler.handleMoodChange(server, player, LeonLeRobotEntity.Mood.SAD);
    }

    private static void handleLeonMoodLove(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        NetworkHandler.handleMoodChange(server, player, LeonLeRobotEntity.Mood.LOVE);
    }

    private static void handleLeonMoodHorny(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        NetworkHandler.handleMoodChange(server, player, LeonLeRobotEntity.Mood.HORNY);
    }

    private static void handleMoodChange(MinecraftServer server, class_3222 player, LeonLeRobotEntity.Mood mood) {
        if (!NetworkHandler.isAuthorizedPlayer((class_1657)player)) {
            return;
        }
        server.execute(() -> {
            LeonLeRobotEntity leon = LeonLeRobotEntity.getInstance();
            if (leon != null && leon.isStreamControlled()) {
                leon.setMood(mood);
            }
        });
    }
}

