/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot;

import com.dremixam.leonlerobot.LeonEntityManager;
import com.dremixam.leonlerobot.LeonLeRobot;
import com.dremixam.leonlerobot.LeonLeRobotEntity;
import com.dremixam.leonlerobot.SoundEventManager;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;

public class ServerEventManager {
    private static int tickCounter = 0;
    private static final int LEON_CHECK_INTERVAL = 1200;

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(LeonEntityManager::initialize);
        ServerTickEvents.END_SERVER_TICK.register(ServerEventManager::onServerTick);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof LeonLeRobotEntity && LeonLeRobotEntity.getInstance() != null && entity != LeonLeRobotEntity.getInstance()) {
                entity.method_5650(class_1297.class_5529.field_26999);
            }
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, source) -> {
            LeonLeRobotEntity leon;
            if (entity instanceof class_1657 && (leon = LeonLeRobotEntity.getInstance()) != null) {
                leon.playVoiceSound(SoundEventManager.LEON_VOICE_DEATH_REACT_SOUND_EVENT);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((player, server) -> {
            LeonLeRobotEntity leon;
            if (player.method_32311().method_5477().getString().equals(LeonLeRobot.INSTANCE.getConfigManager().getFavoritePlayerName()) && (leon = LeonLeRobotEntity.getInstance()) != null) {
                leon.setStreamSpeaking(false);
                leon.setStreamControlled(false);
            }
        });
    }

    private static void onServerTick(MinecraftServer server) {
        if (++tickCounter >= 1200) {
            tickCounter = 0;
            LeonLeRobotEntity leon = LeonLeRobotEntity.getInstance();
            if (leon == null || leon.method_31481()) {
                System.out.println("[LeonLeRobot] Leon a disparu, recr\u00e9ation en cours...");
                LeonEntityManager.reinitialize(server);
            }
        }
    }
}

