/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot.client;

import com.dremixam.leonlerobot.LeonLeRobotEntity;
import com.dremixam.leonlerobot.client.LeonLeRobotEntityModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1144;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4606;
import net.minecraft.class_4608;

@Environment(value=EnvType.CLIENT)
public class LeonLeRobotEyeFeatureRenderer<T extends class_1309>
extends class_4606<T, LeonLeRobotEntityModel<T>> {
    private static final class_2960 EYE_TEXTURE_ID = new class_2960("leonlerobot", "textures/entity/leon/eye.png");
    private static final class_1921 EYE_TEXTURE = class_1921.method_42600((class_2960)EYE_TEXTURE_ID);
    private static final float MIN_INTENSITY = 0.5f;
    private static final float ANIMATION_SPEED = 1.5f;
    private static final class_1144 soundManager = class_310.method_1551().method_1483();

    public LeonLeRobotEyeFeatureRenderer(class_3883<T, LeonLeRobotEntityModel<T>> featureRendererContext) {
        super(featureRendererContext);
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (!(entity instanceof LeonLeRobotEntity)) {
            return;
        }
        LeonLeRobotEntity robotEntity = (LeonLeRobotEntity)((Object)entity);
        if (!robotEntity.isVoicePlaying()) {
            return;
        }
        float[] eyeColor = this.getEyeColor(entity);
        float intensity = this.getAudioIntensity(entity);
        float[] finalColor = new float[]{eyeColor[0] * intensity, eyeColor[1] * intensity, eyeColor[2] * intensity};
        ((LeonLeRobotEntityModel)this.method_17165()).method_2828(matrixStack, vertexConsumerProvider.getBuffer(this.method_23193()), 0xF000F0, class_4608.field_21444, finalColor[0], finalColor[1], finalColor[2], 1.0f);
    }

    public class_1921 method_23193() {
        return EYE_TEXTURE;
    }

    private float[] getEyeColor(T entity) {
        if (entity instanceof LeonLeRobotEntity) {
            float[] fArray;
            LeonLeRobotEntity robotEntity = (LeonLeRobotEntity)((Object)entity);
            LeonLeRobotEntity.Mood mood = robotEntity.getMood();
            switch (mood) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NEUTRAL: {
                    float[] fArray2 = new float[3];
                    fArray2[0] = 0.0f;
                    fArray2[1] = 0.455f;
                    fArray = fArray2;
                    fArray2[2] = 0.851f;
                    break;
                }
                case ANGRY: {
                    float[] fArray3 = new float[3];
                    fArray3[0] = 1.0f;
                    fArray3[1] = 0.2f;
                    fArray = fArray3;
                    fArray3[2] = 0.2f;
                    break;
                }
                case UPSET: {
                    float[] fArray4 = new float[3];
                    fArray4[0] = 0.96f;
                    fArray4[1] = 0.72f;
                    fArray = fArray4;
                    fArray4[2] = 0.24f;
                    break;
                }
                case HAPPY: {
                    float[] fArray5 = new float[3];
                    fArray5[0] = 0.0f;
                    fArray5[1] = 1.0f;
                    fArray = fArray5;
                    fArray5[2] = 0.0f;
                    break;
                }
                case SAD: {
                    float[] fArray6 = new float[3];
                    fArray6[0] = 0.13f;
                    fArray6[1] = 0.07f;
                    fArray = fArray6;
                    fArray6[2] = 0.75f;
                    break;
                }
                case LOVE: {
                    float[] fArray7 = new float[3];
                    fArray7[0] = 1.0f;
                    fArray7[1] = 0.0f;
                    fArray = fArray7;
                    fArray7[2] = 1.0f;
                    break;
                }
                case HORNY: {
                    float[] fArray8 = new float[3];
                    fArray8[0] = 1.0f;
                    fArray8[1] = 0.5f;
                    fArray = fArray8;
                    fArray8[2] = 0.5f;
                }
            }
            return fArray;
        }
        return new float[]{0.0f, 1.0f, 0.0f};
    }

    private float getAudioIntensity(T entity) {
        long seed = ((class_1309)entity).field_6012;
        float base = (float)(Math.sin((double)seed * 0.3 * 1.5) * 0.5 + 0.5);
        float variation1 = (float)(Math.sin((double)seed * 1.7 * 1.5 + 1000.0) * 0.3 + 0.7);
        float variation2 = (float)(Math.sin((double)seed * 0.8 * 1.5 + 2000.0) * 0.2 + 0.8);
        float rawIntensity = base * variation1 * variation2;
        float amplitude = 0.5f;
        return 0.5f + amplitude * rawIntensity;
    }
}

