/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot.client.api;

import com.dremixam.leonlerobot.LeonLeRobot;
import com.dremixam.leonlerobot.client.network.StreamerModePacket;
import com.dremixam.leonlerobot.config.ConfigManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class LeonAPIClient {
    private static final String WS_URL = "ws://localhost:32258";
    private static final int RECONNECT_DELAY_SECONDS = 15;
    private static WebSocket webSocket;
    private static final ScheduledExecutorService scheduler;
    private static ScheduledFuture<?> reconnectFuture;
    private static final Gson gson;
    private static final AtomicBoolean connecting;

    public static void initialize() {
        ConfigManager configManager = LeonLeRobot.INSTANCE.getConfigManager();
        if (configManager.isStreamerEnabled()) {
            LeonAPIClient.connect();
        }
    }

    private static void connect() {
        if (connecting.getAndSet(true)) {
            return;
        }
        HttpClient client = HttpClient.newHttpClient();
        CompletableFuture<WebSocket> ws = client.newWebSocketBuilder().buildAsync(URI.create(WS_URL), new WebSocket.Listener(){

            @Override
            public void onOpen(WebSocket webSocket) {
                connecting.set(false);
                LeonAPIClient.webSocket = webSocket;
                SubscribeMessage subscribe = new SubscribeMessage();
                String subscribeMsg = gson.toJson((Object)subscribe);
                webSocket.sendText(subscribeMsg, true);
                webSocket.request(1L);
                StreamerModePacket.sendLeonClientEnablePacket();
            }

            @Override
            public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                String message = data.toString();
                LeonAPIClient.handleMessage(message);
                webSocket.request(1L);
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                StreamerModePacket.sendLeonClientDisablePacket();
                LeonAPIClient.scheduleReconnect();
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public void onError(WebSocket webSocket, Throwable error) {
                System.err.println("[LeonAPIClient] Erreur WebSocket: " + error.getMessage());
                StreamerModePacket.sendLeonClientDisablePacket();
                error.printStackTrace();
                LeonAPIClient.scheduleReconnect();
            }
        });
        ws.exceptionally(throwable -> {
            System.err.println("[LeonAPIClient] Erreur lors de la connexion: " + throwable.getMessage());
            LeonAPIClient.scheduleReconnect();
            return null;
        });
    }

    private static void scheduleReconnect() {
        if (reconnectFuture != null && !reconnectFuture.isDone()) {
            return;
        }
        connecting.set(false);
        reconnectFuture = scheduler.schedule(LeonAPIClient::connect, 15L, TimeUnit.SECONDS);
    }

    private static void handleMessage(String text) {
        try {
            VoiceRecognitionStatusMessage msg;
            MessageBase base = (MessageBase)gson.fromJson(text, MessageBase.class);
            if (base != null && "VOICE_RECOGNITION_STATUS".equals(base.type) && (msg = (VoiceRecognitionStatusMessage)gson.fromJson(text, VoiceRecognitionStatusMessage.class)) != null && msg.data != null && msg.data.status != null) {
                if (msg.data.status.IsSpeaking) {
                    StreamerModePacket.sendStartSpeakingPacket();
                } else {
                    StreamerModePacket.sendStopSpeakingPacket();
                }
                StreamerModePacket.sendMoodPacket(msg.data.status.Mood);
            }
        }
        catch (Exception e) {
            System.err.println("[LeonAPIClient] Erreur de parsing: " + e.getMessage());
        }
    }

    public static void disconnect() {
        if (reconnectFuture != null && !reconnectFuture.isDone()) {
            reconnectFuture.cancel(false);
            reconnectFuture = null;
        }
        if (webSocket != null) {
            try {
                webSocket.sendClose(1000, "Client disconnecting");
                webSocket = null;
            }
            catch (Exception e) {
                System.err.println("[LeonAPIClient] Erreur lors de la fermeture du WebSocket: " + e.getMessage());
            }
        }
        connecting.set(false);
        StreamerModePacket.sendLeonClientDisablePacket();
    }

    public static void sendExternalEvent(String description) {
        if (webSocket != null && !webSocket.isOutputClosed()) {
            try {
                ExternalEventMessage eventMessage = new ExternalEventMessage(description);
                String message = gson.toJson((Object)eventMessage);
                webSocket.sendText(message, true);
            }
            catch (Exception e) {
                System.err.println("[LeonAPIClient] Erreur lors de l'envoi de l'\u00e9v\u00e9nement externe: " + e.getMessage());
            }
        }
    }

    static {
        scheduler = Executors.newSingleThreadScheduledExecutor();
        gson = new GsonBuilder().create();
        connecting = new AtomicBoolean(false);
    }

    @Environment(value=EnvType.CLIENT)
    private static class MessageBase {
        String type;

        private MessageBase() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class VoiceRecognitionStatusMessage {
        String type;
        Data data;

        private VoiceRecognitionStatusMessage() {
        }

        @Environment(value=EnvType.CLIENT)
        static class Data {
            Status status;

            Data() {
            }

            @Environment(value=EnvType.CLIENT)
            static class Status {
                boolean IsSpeaking;
                String Mood;

                Status() {
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ExternalEventMessage {
        final String type;
        final EventData data;

        public ExternalEventMessage(String description) {
            this.type = "externalEvent";
            this.data = new EventData(description);
        }

        @Environment(value=EnvType.CLIENT)
        record EventData(String message) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class SubscribeMessage {
        String type = "subscribe";
        Data data = new Data();

        private SubscribeMessage() {
        }

        @Environment(value=EnvType.CLIENT)
        static class Data {
            String[] scopes = new String[]{"VOICE_RECOGNITION_STATUS"};

            Data() {
            }
        }
    }
}

