/*
 * Decompiled with CFR 0.152.
 */
package de.henritom.actions.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.henritom.actions.ActionsClient;
import de.henritom.actions.actions.Action;
import de.henritom.actions.actions.ActionEditManager;
import de.henritom.actions.actions.ActionManager;
import de.henritom.actions.region.Region;
import de.henritom.actions.region.RegionManager;
import de.henritom.actions.tasks.Task;
import de.henritom.actions.tasks.TaskEnum;
import de.henritom.actions.triggers.Trigger;
import de.henritom.actions.triggers.TriggerEnum;
import de.henritom.actions.triggers.TriggerManager;
import de.henritom.actions.ui.impl.SettingsScreen;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0003J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u001d\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0003J\r\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010\u0003J\r\u0010!\u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\u0003J\r\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010\u0003R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lde/henritom/actions/config/ConfigManager;", "", "<init>", "()V", "", "saveConfig", "loadConfig", "saveRegions", "loadRegions", "", "name", "", "removeRegion", "(Ljava/lang/String;)Z", "Lde/henritom/actions/actions/Action;", "action", "enabled", "Ljava/io/File;", "saveAction", "(Lde/henritom/actions/actions/Action;Z)Ljava/io/File;", "saveAllActions", "file", "fileName", "copyFileToFolder", "(Ljava/io/File;Ljava/lang/String;)V", "reloadActions", "loadActions", "deleteAction", "(Lde/henritom/actions/actions/Action;)V", "", "getDisabledActions", "()Ljava/util/List;", "reloadRegions", "saveLocalVariables", "loadLocalVariables", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "actions_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nde/henritom/actions/config/ConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n1557#2:330\n1628#2,3:331\n1557#2:334\n1628#2,3:335\n2632#2,3:338\n2632#2,3:341\n2632#2,3:344\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nde/henritom/actions/config/ConfigManager\n*L\n128#1:330\n128#1:331,3\n135#1:334\n135#1:335,3\n215#1:338,3\n236#1:341,3\n258#1:344,3\n*E\n"})
public final class ConfigManager {
    @NotNull
    private final Logger logger;

    public ConfigManager() {
        Logger logger = LoggerFactory.getLogger((String)"actions_legacy");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public final void saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File configFile = FilesKt.resolve((File)configDir, (String)"actions/config.json");
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        if (!configFile.exists()) {
            configFile.createNewFile();
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command_prefix", (Object)ActionManager.Companion.getInstance().getCommandPrefix()), TuplesKt.to((Object)"options_button", (Object)SettingsScreen.addOptionsScreenButton)};
        Map data = MapsKt.mapOf((Pair[])pairArray);
        String string = gson.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)configFile, (String)string, null, (int)2, null);
    }

    public final void loadConfig() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File configFile = FilesKt.resolve((File)configDir, (String)"actions/config.json");
        if (!configFile.exists() || configFile.isDirectory()) {
            return;
        }
        Object object = new Gson().fromJson(FilesKt.readText$default((File)configFile, null, (int)1, null), Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        Map data = (Map)object;
        ActionManager actionManager = ActionManager.Companion.getInstance();
        Object v = data.get("command_prefix");
        String string = v instanceof String ? (String)v : null;
        if (string == null) {
            string = "";
        }
        actionManager.setCommandPrefix(string);
        v = data.get("options_button");
        Boolean bl = v instanceof Boolean ? (Boolean)v : null;
        SettingsScreen.addOptionsScreenButton = bl != null ? bl : true;
    }

    public final void saveRegions() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        for (Region region : RegionManager.Companion.getInstance().getRegions()) {
            Intrinsics.checkNotNull((Object)configDir);
            File configFile = FilesKt.resolve((File)configDir, (String)("actions/regions/" + region.getName() + ".json"));
            if (!configFile.getParentFile().exists()) {
                configFile.getParentFile().mkdirs();
            }
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)region.getName()), TuplesKt.to((Object)"x1", (Object)region.getPos1().field_1352), TuplesKt.to((Object)"y1", (Object)region.getPos1().field_1351), TuplesKt.to((Object)"z1", (Object)region.getPos1().field_1350), TuplesKt.to((Object)"x2", (Object)region.getPos2().field_1352), TuplesKt.to((Object)"y2", (Object)region.getPos2().field_1351), TuplesKt.to((Object)"z2", (Object)region.getPos2().field_1350)};
            Map data = MapsKt.mapOf((Pair[])pairArray);
            String string = gson.toJson((Object)data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)configFile, (String)string, null, (int)2, null);
        }
    }

    public final void loadRegions() {
        File file = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File configDir = FilesKt.resolve((File)file, (String)"actions/regions");
        if (configDir.listFiles() == null) {
            return;
        }
        File[] fileArray = configDir.listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        for (File file2 : fileArray) {
            if (!file2.exists() || file2.isDirectory()) {
                return;
            }
            Gson gson = new Gson();
            Intrinsics.checkNotNull((Object)file2);
            Object object = gson.fromJson(FilesKt.readText$default((File)file2, null, (int)1, null), Map.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map data = (Map)object;
            Object v = data.get("name");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String name = (String)v;
            Object v2 = data.get("x1");
            Double d = v2 instanceof Double ? (Double)v2 : null;
            double x1 = d != null ? d : 0.0;
            Object v3 = data.get("y1");
            Double d2 = v3 instanceof Double ? (Double)v3 : null;
            double y1 = d2 != null ? d2 : 0.0;
            Object v4 = data.get("z1");
            Double d3 = v4 instanceof Double ? (Double)v4 : null;
            double z1 = d3 != null ? d3 : 0.0;
            Object v5 = data.get("x2");
            Double d4 = v5 instanceof Double ? (Double)v5 : null;
            double x2 = d4 != null ? d4 : 0.0;
            Object v6 = data.get("y2");
            Double d5 = v6 instanceof Double ? (Double)v6 : null;
            double y2 = d5 != null ? d5 : 0.0;
            Object v7 = data.get("z2");
            Double d6 = v7 instanceof Double ? (Double)v7 : null;
            double z2 = d6 != null ? d6 : 0.0;
            RegionManager.Companion.getInstance().addRegion(new Region(name, new class_243(x1, y1, z1), new class_243(x2, y2, z2)));
        }
    }

    public final boolean removeRegion(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return FilesKt.resolve((File)file, (String)("actions/regions/" + name + ".json")).delete();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File saveAction(@NotNull Action action, boolean enabled) {
        Pair[] pairArray;
        Task trigger;
        Collection<Map> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File actionFile = FilesKt.resolve((File)configDir, (String)("actions/actions/" + action.getName() + "." + (enabled ? "json" : "disabled")));
        if (!actionFile.getParentFile().exists()) {
            actionFile.getParentFile().mkdirs();
        }
        if (!actionFile.exists()) {
            actionFile.createNewFile();
        }
        Pair[] pairArray2 = new Pair[5];
        pairArray2[0] = TuplesKt.to((Object)"name", (Object)action.getName());
        pairArray2[1] = TuplesKt.to((Object)"preferred_id", (Object)action.getId());
        pairArray2[2] = TuplesKt.to((Object)"author", (Object)action.getAuthor());
        Iterable iterable = action.getTriggers();
        String string = "triggers";
        int n = 3;
        Pair[] pairArray3 = pairArray2;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Trigger trigger2 = (Trigger)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)((Trigger)((Object)trigger)).getId()), TuplesKt.to((Object)"type", (Object)((Object)((Trigger)((Object)trigger)).getType())), TuplesKt.to((Object)"value", (Object)((Trigger)((Object)trigger)).getValue())};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        collection = (List)destination$iv$iv;
        pairArray3[n] = TuplesKt.to((Object)string, (Object)collection);
        $this$map$iv = action.getTasks();
        string = "tasks";
        n = 4;
        pairArray3 = pairArray2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void task;
            trigger = (Task)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)task.getId()), TuplesKt.to((Object)"type", (Object)((Object)task.getType())), TuplesKt.to((Object)"value", (Object)task.getValue())};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        collection = (List)destination$iv$iv;
        pairArray3[n] = TuplesKt.to((Object)string, collection);
        Map data = MapsKt.mapOf((Pair[])pairArray2);
        try {
            String string2 = gson.toJson((Object)data);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
            FilesKt.writeText$default((File)actionFile, (String)string2, null, (int)2, null);
            return actionFile;
        }
        catch (Exception e) {
            this.logger.error("Failed to save action " + action.getName() + "!", (Throwable)e);
            return null;
        }
    }

    public static /* synthetic */ File saveAction$default(ConfigManager configManager, Action action, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return configManager.saveAction(action, bl);
    }

    public final void saveAllActions() {
        this.logger.info("Trying to save all actions...");
        for (Action action : ActionManager.Companion.getInstance().getActions()) {
            ConfigManager.saveAction$default(this, action, false, 2, null);
        }
        this.logger.info("Saved all actions!");
    }

    public final void copyFileToFolder(@NotNull File file, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File actionsDir = FilesKt.resolve((File)configDir, (String)"actions/actions");
        if (!actionsDir.exists()) {
            actionsDir.mkdirs();
        }
        FilesKt.copyTo$default((File)file, (File)FilesKt.resolve((File)actionsDir, (String)fileName), (boolean)true, (int)0, (int)4, null);
    }

    public final void reloadActions() {
        ActionManager.Companion.getInstance().getActions().clear();
        this.loadActions();
    }

    /*
     * WARNING - void declaration
     */
    public final void loadActions() {
        this.logger.info("Trying to load actions...");
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File actionsDir = FilesKt.resolve((File)configDir, (String)"actions/actions");
        if (!actionsDir.exists() || !actionsDir.isDirectory()) {
            this.logger.info("No actions directory found, skipping load.");
            return;
        }
        Gson gson = new Gson();
        File[] fileArray = actionsDir.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) continue;
            try {
                String author;
                String name;
                Object $this$loadActions_u24lambda_u242;
                Intrinsics.checkNotNull((Object)file);
                Object object = gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), Map.class);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                Map data = (Map)object;
                Object v = data.get("name");
                if ((v instanceof String ? (String)v : null) == null) {
                    $this$loadActions_u24lambda_u242 = this;
                    boolean bl = false;
                    continue;
                }
                name = name;
                Object v2 = data.get("preferred_id");
                Double d = v2 instanceof Double ? (Double)v2 : null;
                int preferredID = d != null ? (int)d.doubleValue() : -1;
                $this$loadActions_u24lambda_u242 = data.get("author");
                String string2 = $this$loadActions_u24lambda_u242 instanceof String ? (String)$this$loadActions_u24lambda_u242 : null;
                if (string2 == null) {
                    string2 = author = "Unknown";
                }
                if (ActionManager.Companion.getInstance().createAction(name, false, file) == 1) {
                    List list;
                    Object $this$none$iv;
                    Object trigger;
                    List list2;
                    boolean bl;
                    Object object2;
                    Action action = ActionManager.Companion.getInstance().getActionByNameID(name);
                    if (action == null) {
                        this.logger.error("Failed to load action " + name + "!");
                        continue;
                    }
                    if (action.getId() != preferredID) {
                        boolean bl2;
                        block29: {
                            void $this$none$iv2;
                            $this$loadActions_u24lambda_u242 = ActionManager.Companion.getInstance().getActions();
                            object2 = action;
                            boolean $i$f$none = false;
                            if ($this$none$iv2 instanceof Collection && ((Collection)$this$none$iv2).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$none$iv2) {
                                    Action it = (Action)element$iv;
                                    boolean bl3 = false;
                                    if (!(it.getId() == preferredID)) continue;
                                    bl2 = false;
                                    break block29;
                                }
                                bl2 = true;
                            }
                        }
                        bl = bl2;
                        ((Action)object2).setId(bl ? preferredID : ActionManager.Companion.getInstance().getNextAvailableID());
                    }
                    action.setAuthor(author);
                    if (data.get("triggers") instanceof List) {
                        Object v3 = data.get("triggers");
                        Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                        list2 = (List)v3;
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    List triggers = list2;
                    for (Object triggerIt : triggers) {
                        String triggerValue;
                        String triggerType;
                        Map map = triggerIt instanceof Map ? (Map)triggerIt : null;
                        if (map == null) continue;
                        Map triggerData = map;
                        Object v4 = triggerData.get("id");
                        Double d2 = v4 instanceof Double ? (Double)v4 : null;
                        int triggerID = d2 != null ? (int)d2.doubleValue() : -1;
                        Object v5 = triggerData.get("type");
                        if ((v5 instanceof String ? (String)v5 : null) == null) continue;
                        triggerType = triggerType;
                        Object object3 = triggerData.get("value");
                        Object object4 = object3 instanceof String ? (String)object3 : null;
                        if (object4 == null) {
                            object4 = triggerValue = Integer.valueOf(0);
                        }
                        if (((Trigger)(trigger = new Trigger(action, TriggerEnum.valueOf(triggerType), triggerValue))).getId() != triggerID) {
                            boolean bl4;
                            block30: {
                                object3 = action.getTriggers();
                                object2 = trigger;
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl4 = true;
                                } else {
                                    for (Object element$iv : $this$none$iv) {
                                        Trigger it = (Trigger)element$iv;
                                        boolean bl5 = false;
                                        if (!(it.getId() == triggerID)) continue;
                                        bl4 = false;
                                        break block30;
                                    }
                                    bl4 = true;
                                }
                            }
                            bl = bl4;
                            ((Trigger)object2).setId(bl ? triggerID : TriggerManager.Companion.getInstance().getNextAvailableID(action));
                        }
                        ActionEditManager.Companion.getInstance().addDirectTrigger(action, (Trigger)trigger);
                    }
                    if (data.get("tasks") instanceof List) {
                        Object v6 = data.get("tasks");
                        Intrinsics.checkNotNull(v6, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                        list = (List)v6;
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List tasks = list;
                    for (Object taskIt : tasks) {
                        Task task;
                        String taskValue;
                        String taskType;
                        Map map = taskIt instanceof Map ? (Map)taskIt : null;
                        if (map == null) continue;
                        Map taskData = map;
                        trigger = taskData.get("id");
                        Double d3 = trigger instanceof Double ? (Double)trigger : null;
                        int taskID = d3 != null ? (int)d3.doubleValue() : -1;
                        $this$none$iv = taskData.get("type");
                        if (($this$none$iv instanceof String ? (String)$this$none$iv : null) == null) continue;
                        taskType = taskType;
                        Object $i$f$none = taskData.get("value");
                        String string3 = $i$f$none instanceof String ? (String)$i$f$none : null;
                        if (string3 == null) {
                            string3 = taskValue = "";
                        }
                        if ((task = new Task(action, TaskEnum.valueOf(taskType), taskValue)).getId() != taskID) {
                            boolean bl6;
                            block31: {
                                void $this$none$iv3;
                                $i$f$none = action.getTasks();
                                object2 = task;
                                boolean $i$f$none2 = false;
                                if ($this$none$iv3 instanceof Collection && ((Collection)$this$none$iv3).isEmpty()) {
                                    bl6 = true;
                                } else {
                                    for (Object element$iv : $this$none$iv3) {
                                        Task it = (Task)element$iv;
                                        boolean bl7 = false;
                                        if (!(it.getId() == taskID)) continue;
                                        bl6 = false;
                                        break block31;
                                    }
                                    bl6 = true;
                                }
                            }
                            bl = bl6;
                            ((Task)object2).setId(bl ? taskID : ActionManager.Companion.getInstance().getNextAvailableID());
                        }
                        ActionEditManager.Companion.getInstance().addDirectTask(action, task);
                    }
                    continue;
                }
                this.logger.error("Failed to create action " + name + "!");
            }
            catch (Exception e) {
                this.logger.error("Error loading file " + file.getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        this.logger.info("Loaded actions!");
    }

    public final void deleteAction(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File actionFile = FilesKt.resolve((File)configDir, (String)("actions/actions/" + action.getName() + ".json"));
        if (actionFile.exists()) {
            actionFile.delete();
        }
    }

    @NotNull
    public final List<File> getDisabledActions() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File actionsDir = FilesKt.resolve((File)configDir, (String)"actions/actions");
        if (!actionsDir.exists() || !actionsDir.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        Object object = actionsDir.listFiles(ConfigManager::getDisabledActions$lambda$6);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void reloadRegions() {
        RegionManager.Companion.getInstance().getRegions().clear();
        this.loadRegions();
    }

    public final void saveLocalVariables() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File localVariablesFile = FilesKt.resolve((File)configDir, (String)"actions/local_variables.json");
        if (!localVariablesFile.getParentFile().exists()) {
            localVariablesFile.getParentFile().mkdirs();
        }
        if (!localVariablesFile.exists()) {
            localVariablesFile.createNewFile();
        }
        Map data = MapsKt.mapOf((Pair)TuplesKt.to((Object)"variables", ActionsClient.INSTANCE.getLocalVariableStorage().getVariables()));
        String string = gson.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)localVariablesFile, (String)string, null, (int)2, null);
    }

    public final void loadLocalVariables() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNull((Object)configDir);
        File localVariablesFile = FilesKt.resolve((File)configDir, (String)"actions/local_variables.json");
        if (!localVariablesFile.exists() || localVariablesFile.isDirectory()) {
            return;
        }
        Object object = new Gson().fromJson(FilesKt.readText$default((File)localVariablesFile, null, (int)1, null), Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        Map data = (Map)object;
        Object v = data.get("variables");
        Map map = v instanceof Map ? (Map)v : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map variables = map;
        ActionsClient.INSTANCE.getLocalVariableStorage().getVariables().clear();
        ActionsClient.INSTANCE.getLocalVariableStorage().getVariables().putAll(variables);
    }

    private static final boolean getDisabledActions$lambda$6(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".disabled", (boolean)false, (int)2, null);
    }
}

