/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.fabric;

import earth.terrarium.athena.api.client.fabric.WrappedGetter;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelAttributes;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.models.TintProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AthenaBakedModel
implements class_1087,
FabricBakedModel {
    private static final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033};
    private final AthenaBlockModel model;
    private final Int2ObjectMap<class_1058> textures;
    @Nullable
    private List<class_777>[] defaultQuads = null;

    public AthenaBakedModel(AthenaBlockModel model, Function<class_4730, class_1058> function) {
        this.model = model;
        this.textures = this.model.getTextures(function);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(QuadEmitter emitter, class_1920 level, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, Predicate<@Nullable class_2350> cullTest) {
        WrappedGetter getter = new WrappedGetter(level);
        for (class_2350 value : DIRECTIONS) {
            this.emitQuads(emitter, value, this.model.getQuads(getter, state, pos, value));
        }
    }

    public void emitItemQuads(QuadEmitter emitter, Supplier<class_5819> randomSupplier) {
        for (class_2350 direction : DIRECTIONS) {
            this.emitQuads(emitter, direction, this.model.getDefaultQuads(direction).getOrDefault(direction, List.of()));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emitQuads(QuadEmitter emitter, @Nullable class_2350 side, List<AthenaQuad> quads) {
        AthenaModelAttributes attributes = this.model.getAttributes();
        Iterator<AthenaQuad> iterator = quads.iterator();
        while (iterator.hasNext()) {
            AthenaQuad sprite = iterator.next();
            class_1058 texture = (class_1058)this.textures.get(sprite.sprite());
            if (texture == null) continue;
            emitter.square(side, sprite.left(), sprite.bottom(), sprite.right(), sprite.top(), sprite.depth());
            int flag = 4;
            switch (sprite.rotation()) {
                case field_11463: {
                    flag |= 1;
                    break;
                }
                case field_11464: {
                    flag |= 2;
                    break;
                }
                case field_11465: {
                    flag |= 3;
                    break;
                }
            }
            emitter.spriteBake(texture, flag);
            TintProvider tintProvider = attributes.getTint();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TintProvider.Index.class, TintProvider.Static.class}, (Object)tintProvider, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    int index2;
                    TintProvider.Index index = (TintProvider.Index)tintProvider;
                    try {
                        int n2;
                        index2 = n2 = index.index();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    emitter.tintIndex(index2);
                    break;
                }
                case 1: {
                    int color;
                    TintProvider.Static static_ = (TintProvider.Static)tintProvider;
                    {
                        int n3;
                        color = n3 = static_.color();
                    }
                    emitter.color(color, color, color, color);
                    break;
                }
                case -1: 
            }
            emitter.emit();
        }
        return;
    }

    private List<class_777>[] createDefaultQuads() {
        MutableMesh mesh = Renderer.get().mutableMesh();
        for (class_2350 direction : DIRECTIONS) {
            this.emitQuads(mesh.emitter(), direction, this.model.getDefaultQuads(direction).getOrDefault(direction, List.of()));
        }
        return ModelHelper.toQuadLists((Mesh)mesh.immutableCopy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
        List<class_777>[] defaultQuads = this.defaultQuads;
        if (defaultQuads == null) {
            AthenaBakedModel athenaBakedModel = this;
            synchronized (athenaBakedModel) {
                defaultQuads = this.defaultQuads;
                if (this.defaultQuads == null) {
                    this.defaultQuads = defaultQuads = this.createDefaultQuads();
                }
            }
        }
        return defaultQuads[ModelHelper.toFaceIndex((class_2350)direction)];
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return false;
    }

    @NotNull
    public class_1058 method_4711() {
        if (this.textures.containsKey(0)) {
            return (class_1058)this.textures.get(0);
        }
        return class_310.method_1551().method_1554().method_24153(class_1059.field_5275).method_4608(class_1047.method_4539());
    }

    @NotNull
    public class_809 method_4709() {
        return class_809.field_4301;
    }
}

