/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.fabric;

import earth.terrarium.athena.api.client.fabric.WrappedGetter;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelAttributes;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.models.TintProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AthenaBakedModel
implements class_1087,
FabricBlockStateModel {
    private static final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033};
    private final AthenaBlockModel model;
    private final Int2ObjectMap<class_1058> textures;
    private final class_10889 part;
    @Nullable
    private List<class_777>[] defaultQuads = null;

    public AthenaBakedModel(AthenaBlockModel model, Function<class_4730, class_1058> function) {
        this.model = model;
        this.textures = this.model.getTextures(function);
        this.part = new Part(this);
    }

    public void emitQuads(QuadEmitter emitter, class_1920 level, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        WrappedGetter getter = new WrappedGetter(level);
        for (class_2350 value : DIRECTIONS) {
            this.emitQuads(emitter, value, this.model.getQuads(getter, state, pos, value));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emitQuads(QuadEmitter emitter, @Nullable class_2350 side, List<AthenaQuad> quads) {
        AthenaModelAttributes attributes = this.model.getAttributes();
        class_11515 layer = attributes.getLayer() != null ? attributes.getLayer() : this.model.getLayerType();
        Iterator<AthenaQuad> iterator = quads.iterator();
        while (iterator.hasNext()) {
            AthenaQuad sprite = iterator.next();
            class_1058 texture = (class_1058)this.textures.get(sprite.sprite());
            if (texture == null) continue;
            emitter.square(side, sprite.left(), sprite.bottom(), sprite.right(), sprite.top(), sprite.depth());
            emitter.renderLayer(layer);
            int flag = 4;
            switch (sprite.rotation()) {
                case field_11463: {
                    flag |= 1;
                    break;
                }
                case field_11464: {
                    flag |= 2;
                    break;
                }
                case field_11465: {
                    flag |= 3;
                    break;
                }
            }
            emitter.spriteBake(texture, flag);
            TintProvider tintProvider = attributes.getTint();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TintProvider.Index.class, TintProvider.Static.class}, (Object)tintProvider, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    int index2;
                    TintProvider.Index index = (TintProvider.Index)tintProvider;
                    try {
                        int n2;
                        index2 = n2 = index.index();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    emitter.tintIndex(index2);
                    break;
                }
                case 1: {
                    int color;
                    TintProvider.Static static_ = (TintProvider.Static)tintProvider;
                    {
                        int n3;
                        color = n3 = static_.color();
                    }
                    emitter.color(color, color, color, color);
                    break;
                }
                case -1: 
            }
            emitter.emit();
        }
        return;
    }

    private List<class_777>[] createDefaultQuads() {
        MutableMesh mesh = Renderer.get().mutableMesh();
        for (class_2350 direction : DIRECTIONS) {
            this.emitQuads(mesh.emitter(), direction, this.model.getDefaultQuads(direction).getOrDefault(direction, List.of()));
        }
        return ModelHelper.toQuadLists((Mesh)mesh.immutableCopy());
    }

    public void method_68513(class_5819 randomSource, List<class_10889> list) {
        list.add(this.part);
    }

    @NotNull
    public class_1058 method_68511() {
        return this.part.comp_3752();
    }

    private record Part(AthenaBakedModel model) implements class_10889
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<class_777> method_68509(@Nullable class_2350 direction) {
            List<class_777>[] defaultQuads = this.model.defaultQuads;
            if (defaultQuads == null) {
                Part part = this;
                synchronized (part) {
                    defaultQuads = this.model.defaultQuads;
                    if (this.model.defaultQuads == null) {
                        this.model.defaultQuads = defaultQuads = this.model.createDefaultQuads();
                    }
                }
            }
            return Objects.requireNonNullElse(defaultQuads[ModelHelper.toFaceIndex((class_2350)direction)], List.of());
        }

        public boolean comp_3751() {
            return true;
        }

        @NotNull
        public class_1058 comp_3752() {
            if (this.model.textures.containsKey(0)) {
                return (class_1058)this.model.textures.get(0);
            }
            return class_310.method_1551().method_1554().method_24153(class_1059.field_5275).method_4608(class_1047.method_4539());
        }
    }
}

