/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.CtmState;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.minecraft.class_1059;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class CtmUtils {
    private static final BiPredicate<class_2680, class_2680> FALSE = (selfState, otherState) -> false;
    private static final BiPredicate<class_2680, class_2680> STATE = (selfState, otherState) -> selfState == otherState;
    private static final BiPredicate<class_2680, class_2680> IS = (selfState, otherState) -> selfState.method_27852(otherState.method_26204());

    public static int getTexture(boolean first, boolean second, boolean firstSecond) {
        if (first && second) {
            return firstSecond ? 1 : 2;
        }
        return first ? 3 : (second ? 4 : 0);
    }

    public static Int2ObjectMap<class_4730> parseCtmMaterials(JsonObject json) {
        Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
        materials.put(0, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"particle")));
        materials.put(2, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"center")));
        materials.put(3, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"vertical")));
        materials.put(4, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"horizontal")));
        materials.put(1, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"empty")));
        return materials;
    }

    public static class_4730 blockMat(String id) {
        return new class_4730(class_1059.field_5275, class_2960.method_60654((String)id));
    }

    public static <I, O> O tryParse(I input, Function<I, O> parser) {
        try {
            return parser.apply(input);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_2470 getPillarRotation(class_2350.class_2351 axis, class_2350 direction) {
        if (axis == class_2350.class_2351.field_11048) {
            return direction.method_10166().method_10179() && !AthenaUtils.asBool(direction.method_10171()) ? class_2470.field_11463 : class_2470.field_11465;
        }
        if (axis == class_2350.class_2351.field_11051) {
            if (direction.method_10166().method_10178()) {
                return AthenaUtils.ternary(direction.method_10171(), class_2470.field_11467, class_2470.field_11464);
            }
            return AthenaUtils.ternary(direction.method_10171(), class_2470.field_11463, class_2470.field_11465);
        }
        return class_2470.field_11467;
    }

    public static BiPredicate<class_2680, class_2680> parseCondition(JsonObject json) {
        if (!json.has("connect_to")) {
            return STATE;
        }
        JsonElement jsonElement = json.get("connect_to");
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return CtmUtils.parseConditionInternal(jsonObject);
        }
        return FALSE;
    }

    private static BiPredicate<class_2680, class_2680> parseConditionInternal(JsonObject json) {
        return switch (class_3518.method_15253((JsonObject)json, (String)"type", (String)"")) {
            case "not" -> CtmUtils.parseNotCondition(json);
            case "and" -> CtmUtils.parseListCondition(json, BiPredicate::and);
            case "or" -> CtmUtils.parseListCondition(json, BiPredicate::or);
            case "xor" -> CtmUtils.parseXorCondition(json);
            case "state" -> CtmUtils.parseStateCondition(json);
            case "tag" -> CtmUtils.parseTagCondition(json);
            case "sameBlock" -> IS;
            case "sameState" -> STATE;
            default -> FALSE;
        };
    }

    private static BiPredicate<class_2680, class_2680> parseListCondition(JsonObject json, BinaryOperator<BiPredicate<class_2680, class_2680>> mapper) {
        List<BiPredicate> conditions = CtmUtils.unwrapConditions(json).stream().map(CtmUtils::parseConditionInternal).toList();
        if (conditions.isEmpty()) {
            return FALSE;
        }
        if (conditions.size() == 1) {
            return conditions.getFirst();
        }
        return conditions.stream().reduce(mapper).orElseThrow();
    }

    private static BiPredicate<class_2680, class_2680> parseXorCondition(JsonObject json) {
        List<JsonObject> conditionsJson = CtmUtils.unwrapConditions(json);
        if (conditionsJson.size() != 2) {
            return FALSE;
        }
        BiPredicate<class_2680, class_2680> first = CtmUtils.parseConditionInternal(conditionsJson.get(0));
        BiPredicate<class_2680, class_2680> second = CtmUtils.parseConditionInternal(conditionsJson.get(1));
        return (selfState, otherState) -> first.test((class_2680)selfState, (class_2680)otherState) ^ second.test((class_2680)selfState, (class_2680)otherState);
    }

    private static List<JsonObject> unwrapConditions(JsonObject json) {
        ArrayList<JsonObject> conditionList = new ArrayList<JsonObject>();
        JsonElement jsonElement = json.get("conditions");
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            for (JsonElement jsonElement2 : array) {
                if (!(jsonElement2 instanceof JsonObject)) continue;
                JsonObject jsonObject = (JsonObject)jsonElement2;
                conditionList.add(jsonObject);
            }
        }
        return conditionList;
    }

    private static BiPredicate<class_2680, class_2680> parseNotCondition(JsonObject json) {
        JsonElement jsonElement = json.get("condition");
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return CtmUtils.parseConditionInternal(jsonObject).negate();
        }
        return (selfState, otherState) -> false;
    }

    private static BiPredicate<class_2680, class_2680> parseStateCondition(JsonObject json) {
        Optional blockOpt = Optional.ofNullable(class_3518.method_15253((JsonObject)json, (String)"block", null)).map(class_2960::method_12829).flatMap(arg_0 -> ((class_7922)class_7923.field_41175).method_17966(arg_0));
        if (blockOpt.isEmpty()) {
            return FALSE;
        }
        class_2248 block = (class_2248)blockOpt.get();
        if (!json.has("properties")) {
            return (selfState, otherState) -> otherState.method_27852(block);
        }
        JsonElement propertiesElem = json.get("properties");
        if (!propertiesElem.isJsonObject()) {
            return FALSE;
        }
        HashMap properties = new HashMap();
        for (Map.Entry jsonEntry : propertiesElem.getAsJsonObject().asMap().entrySet()) {
            @Nullable class_2769 property = block.method_9595().method_11663((String)jsonEntry.getKey());
            if (property == null || !class_3518.method_15286((JsonElement)((JsonElement)jsonEntry.getValue()))) continue;
            property.method_11900(((JsonElement)jsonEntry.getValue()).getAsString()).ifPresent(value -> properties.put(property, value));
        }
        return (selfState, otherState) -> {
            if (!otherState.method_27852(block)) {
                return false;
            }
            for (Map.Entry propertyTestValue : properties.entrySet()) {
                if (otherState.method_11654((class_2769)propertyTestValue.getKey()) == propertyTestValue.getValue()) continue;
                return false;
            }
            return true;
        };
    }

    private static BiPredicate<class_2680, class_2680> parseTagCondition(JsonObject json) {
        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_12829((String)json.get("tag").getAsString()));
        return (selfState, otherState) -> otherState.method_26164(tag);
    }

    public static CtmState.ConnectionCheck check(AppearanceAndTintGetter level, class_2680 state, class_2338 pos, class_2350 direction, BiPredicate<class_2680, class_2680> predicate) {
        return (fromPos, fromState, fromAppearance) -> predicate.test(level.getAppearance(state, pos, direction, fromState, fromPos), fromAppearance);
    }

    public static boolean checkRelative(AppearanceAndTintGetter level, class_2680 state, class_2338 pos, class_2350 direction) {
        class_2338 relativePos = pos.method_10093(direction);
        class_2680 otherState = level.method_8320(relativePos);
        class_2680 stateAppearance = level.getAppearance(state, pos, direction, otherState, relativePos);
        class_2680 otherStateAppearance = level.getAppearance(otherState, relativePos, direction.method_10153(), state, pos);
        return !stateAppearance.method_26215() && otherStateAppearance.method_27852(stateAppearance.method_26204());
    }
}

