/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import net.minecraft.class_4730;

public class ConnectedCarpetBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> SIDE = List.of(new AthenaQuad(0, 0.0f, 1.0f, 0.0625f, 0.0f, class_2470.field_11467, 0.0f));
    private static final List<AthenaQuad> CENTER_TOP = List.of(new AthenaQuad(1, 0.0f, 1.0f, 1.0f, 0.0f, class_2470.field_11467, 0.9375f));
    private static final List<AthenaQuad> CENTER_BOTTOM = List.of(new AthenaQuad(1, 0.0f, 1.0f, 1.0f, 0.0f, class_2470.field_11467, 0.0625f));
    private final Int2ObjectMap<class_4730> materials;
    private final BiPredicate<class_2680, class_2680> connectTo;

    public ConnectedCarpetBlockModel(Int2ObjectMap<class_4730> materials, BiPredicate<class_2680, class_2680> connectTo) {
        this.materials = materials;
        this.connectTo = connectTo;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, class_2680 blockState, class_2338 pos, class_2350 direction) {
        if (direction.method_10166().method_10179()) {
            return SIDE;
        }
        CtmState state = CtmState.from(level, blockState, pos, direction, CtmUtils.check(level, blockState, pos, direction, this.connectTo));
        if (state.allTrue()) {
            return direction == class_2350.field_11036 ? CENTER_TOP : CENTER_BOTTOM;
        }
        float depth = direction == class_2350.field_11036 ? 0.9375f : 0.0625f;
        return List.of(AthenaQuad.withState(state.up(), state.left(), state.upLeft(), 0.0f, 0.5f, 1.0f, 0.5f, depth), AthenaQuad.withState(state.up(), state.right(), state.upRight(), 0.5f, 1.0f, 1.0f, 0.5f, depth), AthenaQuad.withState(state.down(), state.left(), state.downLeft(), 0.0f, 0.5f, 0.5f, 0.0f, depth), AthenaQuad.withState(state.down(), state.right(), state.downRight(), 0.5f, 1.0f, 0.5f, 0.0f, depth));
    }

    @Override
    public Map<class_2350, List<AthenaQuad>> getDefaultQuads(class_2350 direction) {
        if (direction == null) {
            return Map.of();
        }
        float depth = direction == class_2350.field_11036 ? 0.9375f : 0.0625f;
        return Map.of(direction, List.of(AthenaQuad.withState(false, false, false, 0.0f, 0.5f, 1.0f, 0.5f, depth), AthenaQuad.withState(false, false, false, 0.5f, 1.0f, 1.0f, 0.5f, depth), AthenaQuad.withState(false, false, false, 0.0f, 0.5f, 0.5f, 0.0f, depth), AthenaQuad.withState(false, false, false, 0.5f, 1.0f, 0.5f, 0.0f, depth)));
    }

    @Override
    public Int2ObjectMap<class_1058> getTextures(Function<class_4730, class_1058> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((class_4730)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<class_4730> materials = CtmUtils.parseCtmMaterials(class_3518.method_15296((JsonObject)json, (String)"ctm_textures"));
            BiPredicate<class_2680, class_2680> conditions = CtmUtils.parseCondition(json);
            return () -> new ConnectedCarpetBlockModel(materials, conditions);
        }
    }
}

