/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.loading;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;

public class AthenaResourceLoader
extends class_4309<JsonElement> {
    private static final String KEY = "athena:loader";
    public static final AthenaResourceLoader INSTANCE = new AthenaResourceLoader();
    private final Map<class_2960, JsonObject> blockstateData = new ConcurrentHashMap<class_2960, JsonObject>();
    private final Map<class_2960, JsonElement> data = new HashMap<class_2960, JsonElement>();

    public AthenaResourceLoader() {
        super(class_5699.field_40721, class_7654.method_45114((String)"athena"));
    }

    public static void clearBlockstateData() {
        AthenaResourceLoader.INSTANCE.blockstateData.clear();
    }

    public static void addBlockstateData(class_2960 stateId, JsonElement data) {
        if (!(data instanceof JsonObject)) {
            return;
        }
        JsonObject object = (JsonObject)data;
        if (!object.has(KEY)) {
            return;
        }
        AthenaResourceLoader.INSTANCE.blockstateData.put(stateId, object);
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        this.data.clear();
        this.data.putAll(object);
    }

    public static JsonObject getData(class_2960 modelType, class_2960 modelId) {
        JsonElement modelData = AthenaResourceLoader.INSTANCE.data.get(modelId);
        if (modelData != null) {
            return AthenaResourceLoader.checkObject(modelType, modelData);
        }
        JsonObject blockstateData = AthenaResourceLoader.INSTANCE.blockstateData.get(modelId);
        if (blockstateData != null) {
            return AthenaResourceLoader.checkObject(modelType, (JsonElement)blockstateData);
        }
        return null;
    }

    private static JsonObject checkObject(class_2960 modelType, JsonElement data) {
        if (data instanceof JsonObject) {
            JsonObject object = (JsonObject)data;
            String type = class_3518.method_15253((JsonObject)object, (String)KEY, (String)"");
            if (modelType.toString().equals(type)) {
                return object;
            }
        }
        return null;
    }
}

