/*
 * Decompiled with CFR 0.152.
 */
package fr.democraft.rcm.smart;

import fr.democraft.rcm.smart.config.MainConfig;
import fr.democraft.rcm.smart.config.Provider;
import fr.democraft.rcm.smart.config.ProviderConfig;
import fr.democraft.rcm.smart.listeners.OnServerLeave;
import fr.democraft.rcm.smart.listeners.OnServerPreJoin;
import fr.democraft.rcm.smart.loggers.ClassicLogger;
import fr.democraft.rcm.smart.loggers.FancyLogger;
import fr.democraft.rcm.smart.loggers.SmartLogger;
import group.aelysium.rustyconnector.common.modules.ExternalModuleBuilder;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.proxy.ProxyKernel;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartProvider
implements Module {
    public static boolean DEBUG = false;
    public static final boolean useFancyLogger = true;
    public static SmartLogger logger;
    public static MainConfig config;
    public static ProviderConfig providerConfig;

    @Nullable
    public Component details() {
        return Component.text((String)"Provides smart server management features.");
    }

    public void close() throws Exception {
    }

    public static class Builder
    extends ExternalModuleBuilder<SmartProvider> {
        public void bind(@NotNull ProxyKernel kernel, @NotNull SmartProvider instance) {
            try {
                config = MainConfig.New();
                providerConfig = ProviderConfig.New();
                DEBUG = SmartProvider.config.debug;
            }
            catch (Exception e) {
                System.out.println("[SmartRC] Failed to load configuration files.");
                e.printStackTrace();
                return;
            }
            logger = SmartProvider.config.fancyLogs ? new FancyLogger() : new ClassicLogger();
            logger.log("Rusty's Smart Provider is booting up, please wait...");
            kernel.fetchModule("EventManager").onStart(m -> {
                m.listen(OnServerPreJoin.class);
                m.listen(OnServerLeave.class);
            });
            if (DEBUG) {
                for (Provider provider : SmartProvider.providerConfig.providers) {
                    logger.debug("Loaded provider: " + provider.id);
                }
            }
            logger.debug("Event registered successfully");
            logger.log("Module loaded successfully");
        }

        @NotNull
        public SmartProvider onStart(@NotNull ExternalModuleBuilder.Context context) throws Exception {
            return new SmartProvider();
        }
    }
}

