/*
 * Decompiled with CFR 0.152.
 */
package fr.democraft.rcm.smart.utils;

import fr.democraft.rcm.smart.SmartProvider;
import fr.democraft.rcm.smart.config.Provider;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ProviderUtils {
    private static final Map<String, AtomicInteger> currentProcesses = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Map<String, AtomicInteger> currentRamUsage = new ConcurrentHashMap<String, AtomicInteger>();

    public static String selectProvider(String familyName, int ramAmount) {
        ArrayList<Provider> eligibleProviders = new ArrayList<Provider>();
        for (Provider provider : SmartProvider.providerConfig.providers) {
            if (!ProviderUtils.isProviderEligible(provider, familyName, ramAmount)) continue;
            eligibleProviders.add(provider);
        }
        if (eligibleProviders.isEmpty()) {
            return null;
        }
        Provider selectedProvider = (Provider)((Object)eligibleProviders.get(0));
        ProviderUtils.allocateResources(selectedProvider.id, ramAmount);
        return selectedProvider.id;
    }

    private static boolean isProviderEligible(Provider provider, String familyName, int ramAmount) {
        if (provider.includedFamilies != null && !provider.includedFamilies.isEmpty() && !provider.includedFamilies.contains(familyName)) {
            return false;
        }
        if (provider.excludedFamilies != null && !provider.excludedFamilies.isEmpty() && provider.excludedFamilies.contains(familyName)) {
            return false;
        }
        int currentProcessCount = ProviderUtils.getCurrentProcessCount(provider.id);
        if (provider.maxProcesses > 0 && currentProcessCount >= provider.maxProcesses) {
            return false;
        }
        int currentRam = ProviderUtils.getCurrentRamUsage(provider.id);
        return provider.ramAmount <= 0 || currentRam + ramAmount <= provider.ramAmount;
    }

    private static void allocateResources(String providerId, int ramAmount) {
        currentProcesses.computeIfAbsent(providerId, k -> new AtomicInteger(0)).incrementAndGet();
        currentRamUsage.computeIfAbsent(providerId, k -> new AtomicInteger(0)).addAndGet(ramAmount);
    }

    public static void releaseResources(String providerId, int ramAmount) {
        currentProcesses.computeIfPresent(providerId, (k, v) -> {
            v.decrementAndGet();
            return v.get() > 0 ? v : null;
        });
        currentRamUsage.computeIfPresent(providerId, (k, v) -> {
            v.addAndGet(-ramAmount);
            return v.get() > 0 ? v : null;
        });
    }

    public static int getCurrentProcessCount(String providerId) {
        AtomicInteger count = currentProcesses.get(providerId);
        return count != null ? count.get() : 0;
    }

    public static int getCurrentRamUsage(String providerId) {
        AtomicInteger usage = currentRamUsage.get(providerId);
        return usage != null ? usage.get() : 0;
    }
}

