package io.github.mattidragon.demobox;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.plasmid.api.game.*;
import xyz.nucleoid.plasmid.api.game.config.CustomValuesConfig;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptor;
import xyz.nucleoid.plasmid.api.game.player.JoinAcceptorResult;
import xyz.nucleoid.plasmid.api.game.player.JoinOffer;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;
import xyz.nucleoid.stimuli.event.EventResult;
import xyz.nucleoid.stimuli.event.player.PlayerDeathEvent;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_1972;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_3492;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class DemoBoxGame {
    public static final GameType<Settings> TYPE = GameType.register(DemoBox.id("demo_box"), Settings.CODEC, DemoBoxGame::open);

    private final class_3218 world;
    private final GameSpace gameSpace;
    private final Settings settings;

    public DemoBoxGame(class_3218 world, GameSpace gameSpace, Settings settings) {
        this.world = world;
        this.gameSpace = gameSpace;
        this.settings = settings;
    }

    public static CompletableFuture<GameSpace> open(Settings settings) {
        var config = new GameConfig<>(TYPE, null, null, null, null, CustomValuesConfig.empty(), settings);
        return GameSpaceManager.get().open(class_6880.method_40223(config));
    }

    private static GameOpenProcedure open(GameOpenContext<Settings> context) {
       return context.openWithWorld(createWorldConfig(context.server().method_30611()), (activity, world) -> {
           var instance = new DemoBoxGame(world, activity.getGameSpace(), context.config());
           instance.setup();
           activity.listen(GamePlayerEvents.OFFER, instance::onPlayerOffered);
           activity.listen(GamePlayerEvents.ACCEPT, instance::onPlayerAccepted);
           activity.listen(GamePlayerEvents.LEAVE, instance::onPlayerLeave);
           activity.listen(GamePlayerEvents.JOIN, instance::onPlayerJoin);
           activity.listen(GamePlayerEvents.JOIN_MESSAGE, instance::onJoinMessage);
           activity.listen(GamePlayerEvents.LEAVE_MESSAGE, instance::onLeaveMessage);
           activity.listen(PlayerDeathEvent.EVENT, (player, source) -> {
               instance.gameSpace.getPlayers().kick(player);
               player.method_64398(class_2561.method_43471("demobox.demo.death").method_27692(class_124.field_1061));
               return EventResult.DENY;
           });
       });
    }

    private void setup() {
        world.method_14183()
                .method_15094(settings.structureId)
                .ifPresent(template -> {
                    var size = template.method_15160();
                    var pos = new class_2338(size.method_10263() / -2, 1, size.method_10260() / -2);
                    template.method_15172(world, pos, pos, new class_3492(), world.field_9229, 0);
                });
        executeFunctions(settings.functions, null);
    }

    private void onPlayerLeave(class_3222 player) {
        if (gameSpace.getPlayers().stream().allMatch(player2 -> player2 != player)) {
            gameSpace.close(GameCloseReason.FINISHED);
        }
    }

    private void onPlayerJoin(class_3222 player) {
        player.method_64398(class_2561.method_43471("demobox.info.1").method_27695(class_124.field_1060, class_124.field_1067));
        player.method_64398(class_2561.method_43471("demobox.info.2").method_27692(class_124.field_1068));
        player.method_64398(class_2561.method_43471("demobox.info.3").method_27692(class_124.field_1068));
        player.method_64398(class_2561.method_43471("demobox.info.4").method_27692(class_124.field_1068));
        executeFunctions(settings.playerFunctions, player);
    }

    private class_2561 onJoinMessage(class_3222 player, @Nullable class_2561 currentText, class_2561 defaultText) {
        return class_2561.method_43469("demobox.demo.join", player.method_5476()).method_27692(class_124.field_1054);
    }

    private class_2561 onLeaveMessage(class_3222 player, @Nullable class_2561 currentText, class_2561 defaultText) {
        return class_2561.method_43469("demobox.demo.leave", player.method_5476()).method_27692(class_124.field_1054);
    }

    private JoinOfferResult onPlayerOffered(JoinOffer offer) {
        return offer.accept();
    }

    private JoinAcceptorResult onPlayerAccepted(JoinAcceptor joinAcceptor) {
        return joinAcceptor.teleport(world, settings.playerPos);
    }

    private void executeFunctions(List<class_2960> functions, class_1297 entity) {
        var server = world.method_8503();
        var manager = server.method_3740();
        for (var id : functions) {
            manager.method_12905(id).ifPresentOrElse(
                function -> manager.method_12904(
                    function,
                    new class_2168(server, class_243.field_1353, class_241.field_1340, world, 2, "DemoBox Setup", class_2561.method_43470("DemoBox Setup"), server, entity).method_9217()
                ),
                () -> DemoBox.LOGGER.warn("Missing function: {}", id)
            );
        }
    }

    @NotNull
    private static RuntimeWorldConfig createWorldConfig(class_5455 registryManager) {
        var worldConfig = new RuntimeWorldConfig();
        worldConfig.setFlat(true);
        var generatorConfig = new class_3232(Optional.of(class_6885.method_40246()), registryManager.method_66874(class_1972.field_9451), List.of());
        generatorConfig.method_14327().add(new class_3229(1, class_2246.field_10499));
        generatorConfig.method_14330();
        worldConfig.setGenerator(new class_2897(generatorConfig));

        var disabledRules = Arrays.asList(class_1928.field_19396, class_1928.field_19406, class_1928.field_19390, class_1928.field_21831, class_1928.field_20637, class_1928.field_21832);
        for (var booleanRuleKey : disabledRules) {
            worldConfig.setGameRule(booleanRuleKey, false);
        }
        worldConfig.setSeed(1);
        return worldConfig;
    }

    public record Settings(class_2960 structureId, class_243 playerPos, List<class_2960> functions, List<class_2960> playerFunctions) {
        public static final MapCodec<Settings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_2960.field_25139.fieldOf("structureId").forGetter(Settings::structureId),
                class_243.field_38277.fieldOf("playerPos").forGetter(Settings::playerPos),
                class_2960.field_25139.listOf().fieldOf("functions").forGetter(Settings::functions),
                class_2960.field_25139.listOf().fieldOf("playerFunctions").forGetter(Settings::playerFunctions)
        ).apply(instance, Settings::new));
    }
}
