package io.github.mattidragon.demobox;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2284;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_3062;
import net.minecraft.class_3485;
import net.minecraft.class_5244;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_8242;
import xyz.nucleoid.plasmid.api.game.GameSpaceManager;
import xyz.nucleoid.plasmid.api.game.player.GamePlayerJoiner;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.util.Scheduler;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;
import static xyz.nucleoid.plasmid.impl.command.GameCommand.NOT_IN_GAME;

public class DemoBoxCommand {
    private static final SuggestionProvider<class_2168> STRUCTURE_SUGGESTION_PROVIDER = (context, builder) -> {
        class_3485 structureTemplateManager = context.getSource().method_9225().method_14183();
        return class_2172.method_9257(structureTemplateManager.method_44226(), builder);
    };

    public static void register() {
        // We need to run after plasmid to be able to redirect to their commands
        CommandRegistrationCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, DemoBox.id("after"));
        CommandRegistrationCallback.EVENT.register(DemoBox.id("after"), (dispatcher, registryAccess, environment) -> {
            dispatcher.register(method_9247("demobox")
                    .requires(Permissions.require("demobox", true))
                    .then(method_9247("leave")
                            .requires(Permissions.require("demobox.leave", true))
                            .executes(DemoBoxCommand::executeLeave))
                    .then(method_9247("open")
                            .requires(Permissions.require("demobox.open", 2))
                            .then(buildArgTree(DemoBoxCommand::executeOpen)))
                    .then(method_9247("sign")
                            .requires(Permissions.require("demobox.sign", 2))
                            .then(method_9244("signPos", class_2262.method_9698())
                                    .then(buildArgTree(DemoBoxCommand::executeSign))))
            );
        });
    }

    private static RequiredArgumentBuilder<class_2168, class_2960> buildArgTree(CommandHandler handler) {
        return method_9244("template", class_2232.method_9441())
                .suggests(STRUCTURE_SUGGESTION_PROVIDER)
                .executes(context -> handler.execute(context, class_2232.method_9443(context, "template"), new class_243(0.5, 2, 0.5), List.of()))
                .then(method_9244("pos", class_2277.method_9737())
                        .executes(context -> handler.execute(context, class_2232.method_9443(context, "template"), class_2277.method_9736(context, "pos"), List.of()))
                        .then(method_9244("setupFunction", class_2284.method_9760())
                                .suggests(class_3062.field_13662)
                                .executes(context -> handler.execute(context, class_2232.method_9443(context, "template"), class_2277.method_9736(context, "pos"), class_2284.method_9769(context, "setupFunction")))));
    }

    // Joinked from GameCommand because brigadier can't deal with childless redirects
    private static int executeLeave(CommandContext<class_2168> context) throws CommandSyntaxException {
        var source = context.getSource();
        var player = source.method_9207();

        var gameSpace = GameSpaceManagerImpl.get().byPlayer(player);
        if (gameSpace == null) {
            throw NOT_IN_GAME.create();
        }

        Scheduler.INSTANCE.submit(server -> {
            gameSpace.getPlayers().kick(player);
        });

        return Command.SINGLE_SUCCESS;
    }

    private static int executeSign(CommandContext<class_2168> context, class_2960 structure, class_243 pos, Collection<class_2158<class_2168>> functions) throws CommandSyntaxException {
        var signPos = class_2262.method_9696(context, "signPos");
        var source = context.getSource();
        var block = source.method_9225().method_8320(signPos).method_26204();
        if (!(source.method_9225().method_8321(signPos) instanceof class_2625 sign)) {
            source.method_9213(class_2561.method_43471("command.demobox.sign.missing"));
            return 0;
        }

        var command = "demobox open " + getCommandEnd(context);

        UnaryOperator<class_8242> textChanger = text -> {
            var clickEvent = new class_2558.class_10609(command);
            class_2561[] texts;
            if (block instanceof class_7713 || block instanceof class_7715) {
                texts = new class_2561[]{
                        class_2561.method_43471("demobox.hanging_sign.line1").method_27692(class_124.field_1060)
                                .method_27694(style -> style.method_10958(clickEvent)),
                        class_2561.method_43471("demobox.hanging_sign.line2").method_27692(class_124.field_1060),
                        class_2561.method_43471("demobox.hanging_sign.line3").method_27692(class_124.field_1060),
                        class_5244.field_39003
                };
            } else {
                texts = new class_2561[]{
                        class_5244.field_39003,
                        class_2561.method_43471("demobox.sign.line1").method_27692(class_124.field_1060)
                                .method_27694(style -> style.method_10958(clickEvent)),
                        class_2561.method_43471("demobox.sign.line2").method_27692(class_124.field_1060),
                        class_5244.field_39003
                };
            }
            return new class_8242(
                    texts,
                    texts,
                    class_1767.field_7961,
                    true
            );
        };
        sign.method_49841(textChanger, true);
        sign.method_49841(textChanger, false);
        sign.method_49849(true);

        source.method_9226(() -> class_2561.method_43471("command.demobox.sign.success"), true);
        return 1;
    }

    /**
     * Extracts the argument text from the sign command for use within the sign text.
     */
    private static String getCommandEnd(CommandContext<class_2168> context) {
        var nodes = context.getNodes();
        ParsedCommandNode<class_2168> mainNode = null;
        for (var i = nodes.size() - 1; i >= 0; i--) {
            var node = nodes.get(i);
            if (node.getNode() instanceof LiteralCommandNode<class_2168> literal && literal.getLiteral().equals("sign")) {
                mainNode = nodes.get(i + 2);
                break;
            }
        }
        if (mainNode == null) {
            throw new IllegalStateException("Cannot find node in parsed command (weird hacks going on???)");
        }
        return context.getInput().substring(mainNode.getRange().getStart());
    }

    private static int executeOpen(CommandContext<class_2168> context, class_2960 structure, class_243 pos, Collection<class_2158<class_2168>> functions) throws CommandSyntaxException {
        var source = context.getSource();
        var player = source.method_9207();

        DemoBoxGame.open(new DemoBoxGame.Settings(structure, pos, functions.stream().map(class_2158::comp_1994).toList()))
                .thenAcceptAsync(gameSpace -> {
                    var space = GameSpaceManager.get().byPlayer(player);
                    if (space != null) space.getPlayers().kick(player);

                    var results = GamePlayerJoiner.tryJoin(player, gameSpace, JoinIntent.PLAY);
                    if (results.error() != null) {
                        source.method_9213(class_2561.method_43471("command.demobox.open.fail"));
                    }
                }, player.method_5682());
        return Command.SINGLE_SUCCESS;
    }

    @FunctionalInterface
    private interface CommandHandler {
        int execute(CommandContext<class_2168> context, class_2960 structure, class_243 pos, Collection<class_2158<class_2168>> functions) throws CommandSyntaxException;
    }
}
