/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.menu.MenuRegistry;
import infinituum.fastconfigapi.FastConfigs;
import infinituum.labellingcontainers.LabellingContainers;
import infinituum.labellingcontainers.config.CompatibleContainers;
import infinituum.labellingcontainers.config.PlayerPreferences;
import infinituum.labellingcontainers.events.TooltipEventHandler;
import infinituum.labellingcontainers.guis.LabelPrinterGui;
import infinituum.labellingcontainers.huds.HudInfoDisplay;
import infinituum.labellingcontainers.huds.LabelPrinterHudInfoDisplay;
import infinituum.labellingcontainers.huds.utils.HudPositions;
import infinituum.labellingcontainers.items.LabelPrinterItem;
import infinituum.labellingcontainers.network.Packets;
import infinituum.labellingcontainers.registration.ItemRegistration;
import infinituum.labellingcontainers.registration.ScreenRegistration;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public final class LabellingContainersSetup {
    public static void initClient() {
        if (Platform.getEnv() == EnvType.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(client -> {
                LabellingContainersSetup.clientRegisterScreens();
                LabellingContainersSetup.clientRegisterEvents();
                LabellingContainersSetup.clientRegisterNetworkReceivers();
            });
        } else {
            LabellingContainers.LOGGER.warn("Could not run Client Setup (mod is probably running on a Server-Only instance)");
        }
    }

    public static void initServer() {
        LabellingContainersSetup.serverRegisterNetworkReceivers();
    }

    public static void serverRegisterNetworkReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)Packets.C2S_REQUEST_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> {
            CompatibleContainers config = (CompatibleContainers)FastConfigs.get(CompatibleContainers.class);
            class_2540 buffer = new class_2540(Unpooled.buffer());
            Set<String> ids = config.getIds();
            Set<String> tags = config.getTags();
            buffer.writeInt(ids.size());
            ids.forEach(arg_0 -> ((class_2540)buffer).method_10814(arg_0));
            buffer.writeInt(tags.size());
            tags.forEach(arg_0 -> ((class_2540)buffer).method_10814(arg_0));
            NetworkManager.sendToPlayer((class_3222)((class_3222)context.getPlayer()), (class_2960)Packets.S2C_SYNC_TAGGABLE_BLOCKS_CONFIG, (class_2540)buffer);
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)Packets.C2S_LABEL_PRINTER_SAVE, (buf, context) -> {
            String label = buf.method_19772();
            class_1799 itemInHand = context.getPlayer().method_6047();
            if (!itemInHand.method_7960() && itemInHand.method_31574((class_1792)ItemRegistration.LABEL_PRINTER.get())) {
                LabelPrinterItem.setLabel(itemInHand, label);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientRegisterScreens() {
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)ScreenRegistration.LABEL_PRINTER_SCREEN_HANDLER.get()), LabelPrinterGui::new);
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientRegisterEvents() {
        ClientTooltipEvent.ITEM.register(TooltipEventHandler::handle);
        ClientGuiEvent.RENDER_HUD.register((Object)new HudInfoDisplay());
        ClientGuiEvent.RENDER_HUD.register((Object)new LabelPrinterHudInfoDisplay());
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> NetworkManager.sendToServer((class_2960)Packets.C2S_REQUEST_TAGGABLE_BLOCKS_CONFIG, (class_2540)new class_2540(Unpooled.buffer())));
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientRegisterNetworkReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)Packets.S2C_PREFERENCES_CONFIG_UPDATE, (buf, context) -> FastConfigs.editAndSave(PlayerPreferences.class, config -> {
            String ordinalHud = buf.method_19772();
            config.setHudPosition(HudPositions.fromReadable(ordinalHud));
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)Packets.S2C_SYNC_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> {
            int idsSize = buf.readInt();
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < idsSize; ++i) {
                ids.add(buf.method_19772());
            }
            int tagsSize = buf.readInt();
            HashSet<String> tags = new HashSet<String>();
            for (int i = 0; i < tagsSize; ++i) {
                tags.add(buf.method_19772());
            }
            config.setIds(ids);
            config.setTags(tags);
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)Packets.S2C_ADD_ID_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.addId(buf.method_19772())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)Packets.S2C_REMOVE_ID_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.removeId(buf.method_19772())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)Packets.S2C_ADD_TAG_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.addTag(buf.method_19772())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)Packets.S2C_REMOVE_TAG_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.removeTag(buf.method_19772())));
    }
}

