/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.fabric;

import infinituum.labellingcontainers.fabric.providers.ModelProvider;
import infinituum.labellingcontainers.fabric.providers.RecipeProvider;
import infinituum.labellingcontainers.fabric.providers.language.EnglishLangProvider;
import infinituum.labellingcontainers.fabric.providers.language.ItalianLangProvider;
import infinituum.labellingcontainers.fabric.providers.language.SpanishLangProvider;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;

public final class LabellingContainersDataGeneration
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(ModelProvider::new);
        this.registerLanguages(pack);
    }

    private void registerLanguages(FabricDataGenerator.Pack pack) {
        pack.addProvider(EnglishLangProvider::new);
        pack.addProvider(ItalianLangProvider::new);
        List<String> languageCodes = List.of("es_mx", "es_ve", "es_es", "es_ar", "es_ec", "es_cl", "es_uy");
        Consumer<String> addProvider = languageCode -> pack.addProvider(dataOutput -> new SpanishLangProvider(dataOutput, (String)languageCode));
        languageCodes.forEach(addProvider);
    }
}

