/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.items;

import dev.architectury.registry.menu.MenuRegistry;
import infinituum.fastconfigapi.FastConfigs;
import infinituum.labellingcontainers.config.CompatibleContainers;
import infinituum.labellingcontainers.registration.ItemRegistration;
import infinituum.labellingcontainers.screens.LabelPrinterScreenFactory;
import infinituum.labellingcontainers.utils.ActionBarTextHelper;
import infinituum.labellingcontainers.utils.BlockEntityHelper;
import infinituum.labellingcontainers.utils.InventoryHelper;
import infinituum.labellingcontainers.utils.Taggable;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPrinterItem
extends class_1792 {
    public LabelPrinterItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static String getLabel(class_1799 itemStack) {
        class_2487 labelTag = itemStack.method_7911("Label");
        if (!labelTag.method_10545("text")) {
            labelTag.method_10582("text", "");
        }
        return labelTag.method_10558("text");
    }

    public static void setLabel(class_1799 itemStack, String text) {
        class_2487 tag = itemStack.method_7911("Label");
        tag.method_10582("text", text);
        itemStack.method_7959("Label", (class_2520)tag);
    }

    public static class_1792 getDisplayItem(class_1799 itemStack) {
        class_2487 labelTag = itemStack.method_7911("Label");
        if (!labelTag.method_10545("displayItem")) {
            labelTag.method_10566("displayItem", (class_2520)class_1799.field_8037.method_7953(new class_2487()));
        }
        return class_1799.method_7915((class_2487)labelTag.method_10562("displayItem")).method_7909();
    }

    public static void setDisplayItem(class_1799 itemStack, class_1799 itemToDisplay) {
        class_2487 tag = itemStack.method_7911("Label");
        tag.method_10566("displayItem", (class_2520)itemToDisplay.method_7953(new class_2487()));
        itemStack.method_7959("Label", (class_2520)tag);
    }

    public static int getModeIndex(class_1799 itemStack) {
        class_2487 labelTag = itemStack.method_7911("Label");
        if (!labelTag.method_10545("modeIndex")) {
            labelTag.method_10569("modeIndex", 0);
        }
        return labelTag.method_10550("modeIndex");
    }

    public static LabelPrinterMode getMode(class_1799 itemStack) {
        int i = LabelPrinterItem.getModeIndex(itemStack);
        return LabelPrinterMode.fromIndex(i);
    }

    public static void setModeIndex(class_1799 itemStack, int modeIndex) {
        class_2487 tag = itemStack.method_7911("Label");
        tag.method_10569("modeIndex", modeIndex);
        itemStack.method_7959("Label", (class_2520)tag);
    }

    public static void setMode(class_1799 itemStack, LabelPrinterMode mode) {
        int i = mode.ordinal();
        LabelPrinterItem.setModeIndex(itemStack, i);
    }

    private class_1269 interactionFail(class_1937 level, class_243 hitPos, class_2338 pos) {
        ((class_3218)level).method_14199((class_2394)class_2398.field_11251, hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), 15, 0.0, 0.0, 0.0, 0.01);
        level.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.75f, 2.0f);
        return class_1269.field_5814;
    }

    private class_1269 interactionFail(class_1937 level, class_243 hitPos, class_2338 pos, class_1657 player, String errorTranslationKey) {
        ActionBarTextHelper.sendMessage((class_3222)player, (class_2561)class_2561.method_43471((String)(((class_1792)ItemRegistration.LABEL_PRINTER.get()).method_7876() + errorTranslationKey)).method_27692(class_124.field_1061));
        return this.interactionFail(level, hitPos, pos);
    }

    private class_1269 interactionSuccess(class_1937 level, class_243 hitPos, class_2338 pos) {
        ((class_3218)level).method_14199((class_2394)class_2398.field_11207, hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), 15, 0.0, 0.0, 0.0, 0.01);
        level.method_8396(null, pos, (class_3414)class_3417.field_15114.comp_349(), class_3419.field_15245, 0.75f, 2.0f);
        return class_1269.field_5812;
    }

    private class_1269 interactionSuccess(class_1937 level, class_243 hitPos, class_2338 pos, class_1657 player, String successTranslationKey) {
        ActionBarTextHelper.sendMessage((class_3222)player, (class_2561)class_2561.method_43471((String)(((class_1792)ItemRegistration.LABEL_PRINTER.get()).method_7876() + successTranslationKey)).method_27692(class_124.field_1065));
        return this.interactionSuccess(level, hitPos, pos);
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        if (player == null) {
            return super.method_7884(context);
        }
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_1661 inventory = player.method_31548();
        class_2338 clickedBlockPosition = context.method_8037();
        class_1799 itemInHand = context.method_8041();
        class_2680 blockState = level.method_8320(clickedBlockPosition);
        class_2960 registryName = blockState.method_26204().method_8389().arch$registryName();
        class_243 hitPosVec3 = context.method_17698();
        if (registryName == null) {
            return super.method_7884(context);
        }
        class_2586 blockEntity = BlockEntityHelper.locateTargetBlockEntity(level, clickedBlockPosition, blockState);
        if (!(blockEntity instanceof Taggable)) {
            if (player.method_18276()) {
                this.swapMode(itemInHand);
            } else {
                MenuRegistry.openMenu((class_3222)((class_3222)player), (class_3908)new LabelPrinterScreenFactory());
            }
            return class_1269.field_5812;
        }
        Taggable taggable = (Taggable)blockEntity;
        class_5250 printerLabel = class_2561.method_43470((String)LabelPrinterItem.getLabel(itemInHand));
        class_1792 printerDisplayItem = LabelPrinterItem.getDisplayItem(itemInHand);
        class_5250 blockLabel = taggable.labellingcontainers$getLabel();
        class_1792 blockDisplayItem = taggable.labellingcontainers$getDisplayItem();
        CompatibleContainers config = (CompatibleContainers)FastConfigs.get(CompatibleContainers.class);
        boolean dataIsEqual = blockLabel.equals((Object)printerLabel) && blockDisplayItem.equals(printerDisplayItem);
        switch (LabelPrinterItem.getMode(itemInHand).ordinal()) {
            case 0: {
                if (config.isLimited() && !config.has(registryName.toString()) && !config.hasAnyTag(blockState.method_40144())) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition, player, ".untaggable.error");
                }
                if (!inventory.method_7379(class_1802.field_8407.method_7854()) && !player.method_7337()) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition, player, ".paper.error");
                }
                if (dataIsEqual) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition);
                }
                if (!player.method_7337()) {
                    InventoryHelper.removeOneItemFromInventory(inventory, class_1802.field_8407);
                }
                taggable.labellingcontainers$setLabel(printerLabel, true);
                taggable.labellingcontainers$setDisplayItem(printerDisplayItem, true);
                return this.interactionSuccess(level, hitPosVec3, clickedBlockPosition);
            }
            case 1: {
                if (config.isLimited() && !config.has(registryName.toString()) && !config.hasAnyTag(blockState.method_40144())) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition, player, ".mode.copy.error");
                }
                if (dataIsEqual) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition);
                }
                LabelPrinterItem.setLabel(itemInHand, blockLabel.getString());
                LabelPrinterItem.setDisplayItem(itemInHand, blockDisplayItem.method_7854());
                return this.interactionSuccess(level, hitPosVec3, clickedBlockPosition, player, ".mode.copy.success");
            }
        }
        return super.method_7884(context);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (level.method_8608()) {
            return super.method_7836(level, player, hand);
        }
        if (hand == class_1268.field_5808) {
            if (player.method_18276()) {
                this.swapMode(player.method_5998(hand));
            } else {
                MenuRegistry.openMenu((class_3222)((class_3222)player), (class_3908)new LabelPrinterScreenFactory());
            }
        }
        return super.method_7836(level, player, hand);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 context) {
        String currentLabel = LabelPrinterItem.getLabel(stack);
        class_1792 currentDisplayItem = LabelPrinterItem.getDisplayItem(stack);
        int currentModeIndex = LabelPrinterItem.getModeIndex(stack);
        class_5250 descriptionText = class_2561.method_43470((String)"\u24d8 ").method_27692(class_124.field_1078);
        if (level != null && level.method_8608() && class_437.method_25442()) {
            descriptionText.method_10852((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip.description")).method_27692(class_124.field_1060));
        } else {
            descriptionText.method_10852((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip.hidden")).method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)descriptionText);
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        class_5250 labelText = class_2561.method_43470((String)"\u25cf ").method_27692(class_124.field_1080);
        labelText.method_10852((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip.label")).method_27692(class_124.field_1080));
        if (currentLabel.isEmpty()) {
            labelText.method_10852((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip.none")).method_27692(class_124.field_1079));
        } else {
            labelText.method_10852((class_2561)class_2561.method_43470((String)("\"" + currentLabel + "\"")).method_27692(class_124.field_1065));
        }
        tooltip.add((class_2561)labelText);
        class_5250 displayItemText = class_2561.method_43470((String)"\u25cf ").method_27692(class_124.field_1080);
        displayItemText.method_10852((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip.display_item")).method_27692(class_124.field_1080));
        if (currentDisplayItem.equals(class_1802.field_8162)) {
            displayItemText.method_10852((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip.none")).method_27692(class_124.field_1079));
        } else {
            displayItemText.method_10852((class_2561)currentDisplayItem.method_7848().method_27661().method_27692(class_124.field_1075));
        }
        tooltip.add((class_2561)displayItemText);
        class_5250 modeText = class_2561.method_43470((String)"\u25cf ").method_27692(class_124.field_1080);
        modeText.method_10852((class_2561)class_2561.method_43471((String)(this.method_7876() + ".tooltip.mode")).method_27692(class_124.field_1080));
        modeText.method_10852(LabelPrinterMode.fromIndex(currentModeIndex).getDisplayable());
        tooltip.add((class_2561)modeText);
        super.method_7851(stack, level, tooltip, context);
    }

    private void swapMode(class_1799 currentItemStack) {
        LabelPrinterMode mode = LabelPrinterItem.getMode(currentItemStack);
        LabelPrinterItem.setMode(currentItemStack, mode.swap());
    }

    public static enum LabelPrinterMode {
        CREATE((class_2561)class_2561.method_43471((String)"item.labellingcontainers.label_printer.mode.create").method_27692(class_124.field_1061)),
        COPY((class_2561)class_2561.method_43471((String)"item.labellingcontainers.label_printer.mode.copy").method_27692(class_124.field_1065));

        private final class_2561 name;

        private LabelPrinterMode(class_2561 s) {
            this.name = s;
        }

        public static LabelPrinterMode fromIndex(int index) {
            return LabelPrinterMode.values()[index];
        }

        public class_2561 getDisplayable() {
            return this.name;
        }

        public LabelPrinterMode swap() {
            if (this == CREATE) {
                return COPY;
            }
            return CREATE;
        }
    }
}

