/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.registration;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.networking.NetworkManager;
import infinituum.fastconfigapi.FastConfigs;
import infinituum.fastconfigapi.api.FastConfigFile;
import infinituum.labellingcontainers.config.CompatibleContainers;
import infinituum.labellingcontainers.huds.utils.HudPositions;
import infinituum.labellingcontainers.network.Packets;
import infinituum.labellingcontainers.utils.Taggable;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2277;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public final class CommandRegistration {
    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setlabel").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9247((String)"label").then(class_2170.method_9244((String)"label", (ArgumentType)class_2196.method_9340()).executes(context -> {
                class_2338 pos = class_2277.method_9734((CommandContext)context, (String)"location").method_9704((class_2168)context.getSource());
                class_5250 label = class_2196.method_9339((CommandContext)context, (String)"label").method_27661();
                class_3218 level = ((class_2168)context.getSource()).method_9225();
                class_2586 be = level.method_8321(pos);
                if (be instanceof Taggable) {
                    Taggable labelable = (Taggable)be;
                    labelable.labellingcontainers$setLabel(label, true);
                }
                return 1;
            })))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setlabel").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"display-item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(context -> {
                class_2338 pos = class_2277.method_9734((CommandContext)context, (String)"location").method_9704((class_2168)context.getSource());
                class_1792 item = class_2287.method_9777((CommandContext)context, (String)"display-item").method_9785();
                class_3218 level = ((class_2168)context.getSource()).method_9225();
                class_2586 be = level.method_8321(pos);
                if (be instanceof Taggable) {
                    Taggable labelable = (Taggable)be;
                    labelable.labellingcontainers$setDisplayItem(item, true);
                }
                return 1;
            })))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add-hand").requires(class_2168::method_43737)).executes(context -> {
                class_2168 commandContext = (class_2168)context.getSource();
                if (commandContext == null) {
                    return 0;
                }
                class_3222 player = commandContext.method_44023();
                if (player == null) {
                    return 0;
                }
                class_1792 item = player.method_5998(class_1268.field_5808).method_7909();
                class_2960 resourceLocation = item.arch$registryName();
                return CommandRegistration.addId((CommandContext<class_2168>)context, resourceLocation);
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove-hand").requires(class_2168::method_43737)).executes(context -> {
                class_2168 commandContext = (class_2168)context.getSource();
                if (commandContext == null) {
                    return 0;
                }
                class_3222 player = commandContext.method_44023();
                if (player == null) {
                    return 0;
                }
                class_1792 item = player.method_5998(class_1268.field_5808).method_7909();
                class_2960 resourceLocation = item.arch$registryName();
                return CommandRegistration.removeId((CommandContext<class_2168>)context, resourceLocation);
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"add-item").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(context -> {
                class_2168 commandContext = (class_2168)context.getSource();
                class_1792 item = class_2287.method_9777((CommandContext)context, (String)"item").method_9785();
                if (commandContext == null) {
                    return 0;
                }
                class_3222 player = commandContext.method_44023();
                if (player == null) {
                    return 0;
                }
                class_2960 resourceLocation = item.arch$registryName();
                return CommandRegistration.addId((CommandContext<class_2168>)context, resourceLocation);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"remove-item").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(context -> {
                class_2168 commandContext = (class_2168)context.getSource();
                class_1792 item = class_2287.method_9777((CommandContext)context, (String)"item").method_9785();
                if (commandContext == null) {
                    return 0;
                }
                class_3222 player = commandContext.method_44023();
                if (player == null) {
                    return 0;
                }
                class_2960 resourceLocation = item.arch$registryName();
                return CommandRegistration.removeId((CommandContext<class_2168>)context, resourceLocation);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"add-tag").then(class_2170.method_9244((String)"tag", (ArgumentType)class_2196.method_9340()).executes(context -> {
                class_2168 commandContext = (class_2168)context.getSource();
                String tag = class_2196.method_9339((CommandContext)context, (String)"tag").getString();
                if (commandContext == null) {
                    return 0;
                }
                class_3222 player = commandContext.method_44023();
                if (player == null) {
                    return 0;
                }
                return CommandRegistration.addTag((CommandContext<class_2168>)context, tag);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"remove-tag").then(class_2170.method_9244((String)"item", (ArgumentType)class_2196.method_9340()).executes(context -> {
                class_2168 commandContext = (class_2168)context.getSource();
                String tag = class_2196.method_9339((CommandContext)context, (String)"item").getString();
                if (commandContext == null) {
                    return 0;
                }
                class_3222 player = commandContext.method_44023();
                if (player == null) {
                    return 0;
                }
                return CommandRegistration.removeTag((CommandContext<class_2168>)context, tag);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelposition").requires(class_2168::method_43737)).then(class_2170.method_9247((String)"top").executes(context -> CommandRegistration.setLabelPosition((CommandContext<class_2168>)context, HudPositions.TOP))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelposition").requires(class_2168::method_43737)).then(class_2170.method_9247((String)"top-left").executes(context -> CommandRegistration.setLabelPosition((CommandContext<class_2168>)context, HudPositions.TOP_LEFT))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelposition").requires(class_2168::method_43737)).then(class_2170.method_9247((String)"center-left").executes(context -> CommandRegistration.setLabelPosition((CommandContext<class_2168>)context, HudPositions.CENTER_LEFT))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelposition").requires(class_2168::method_43737)).then(class_2170.method_9247((String)"center-right").executes(context -> CommandRegistration.setLabelPosition((CommandContext<class_2168>)context, HudPositions.CENTER_RIGHT))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"labelposition").requires(class_2168::method_43737)).then(class_2170.method_9247((String)"left").executes(context -> CommandRegistration.setLabelPosition((CommandContext<class_2168>)context, HudPositions.LEFT))));
        });
    }

    private static int setLabelPosition(CommandContext<class_2168> context, HudPositions position) {
        class_2168 sourceStack = (class_2168)context.getSource();
        class_3222 player = sourceStack.method_44023();
        if (player == null) {
            return 0;
        }
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10814(HudPositions.toReadable(position));
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)Packets.S2C_PREFERENCES_CONFIG_UPDATE, (class_2540)buffer);
        return 1;
    }

    private static int addId(CommandContext<class_2168> context, class_2960 resourceLocation) {
        class_2168 commandContext = (class_2168)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        class_3222 player = commandContext.method_44023();
        if (player == null || resourceLocation == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (config.has(resourceLocation.toString())) {
            return 0;
        }
        config.addId(resourceLocation.toString());
        configFile.save();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10814(resourceLocation.toString());
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)Packets.S2C_ADD_ID_TAGGABLE_BLOCKS_CONFIG, (class_2540)buffer);
        player.method_43496((class_2561)class_2561.method_43469((String)"command.labelconfig.addition.success", (Object[])new Object[]{resourceLocation.toString()}));
        return 1;
    }

    private static int removeId(CommandContext<class_2168> context, class_2960 resourceLocation) {
        class_2168 commandContext = (class_2168)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        class_3222 player = commandContext.method_44023();
        if (player == null || resourceLocation == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (!config.has(resourceLocation.toString())) {
            return 0;
        }
        config.removeId(resourceLocation.toString());
        configFile.save();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10814(resourceLocation.toString());
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)Packets.S2C_REMOVE_ID_TAGGABLE_BLOCKS_CONFIG, (class_2540)buffer);
        player.method_43496((class_2561)class_2561.method_43469((String)"command.labelconfig.removal.success", (Object[])new Object[]{resourceLocation.toString()}));
        return 1;
    }

    private static int addTag(CommandContext<class_2168> context, String tag) {
        class_2168 commandContext = (class_2168)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        class_3222 player = commandContext.method_44023();
        if (player == null || tag == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (config.has(tag)) {
            return 0;
        }
        config.addTag(tag);
        configFile.save();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10814(tag);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)Packets.S2C_ADD_TAG_TAGGABLE_BLOCKS_CONFIG, (class_2540)buffer);
        player.method_43496((class_2561)class_2561.method_43469((String)"command.labelconfig.addition.success", (Object[])new Object[]{tag}));
        return 1;
    }

    private static int removeTag(CommandContext<class_2168> context, String tag) {
        class_2168 commandContext = (class_2168)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        class_3222 player = commandContext.method_44023();
        if (player == null || tag == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (!config.has(tag)) {
            return 0;
        }
        config.removeTag(tag);
        configFile.save();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10814(tag);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)Packets.S2C_REMOVE_TAG_TAGGABLE_BLOCKS_CONFIG, (class_2540)buffer);
        player.method_43496((class_2561)class_2561.method_43469((String)"command.labelconfig.removal.success", (Object[])new Object[]{tag}));
        return 1;
    }
}

