/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.menu.MenuRegistry;
import infinituum.fastconfigapi.FastConfigs;
import infinituum.labellingcontainers.LabellingContainers;
import infinituum.labellingcontainers.config.CompatibleContainers;
import infinituum.labellingcontainers.config.PlayerPreferences;
import infinituum.labellingcontainers.events.TooltipEventHandler;
import infinituum.labellingcontainers.guis.LabelPrinterGui;
import infinituum.labellingcontainers.huds.HudInfoDisplay;
import infinituum.labellingcontainers.huds.LabelPrinterHudInfoDisplay;
import infinituum.labellingcontainers.huds.utils.HudPositions;
import infinituum.labellingcontainers.items.LabelPrinterItem;
import infinituum.labellingcontainers.network.Packets;
import infinituum.labellingcontainers.registration.ItemRegistration;
import infinituum.labellingcontainers.registration.ScreenRegistration;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class LabellingContainersSetup {
    public static void initClient() {
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(client -> {
                LabellingContainersSetup.clientRegisterScreens();
                LabellingContainersSetup.clientRegisterEvents();
                LabellingContainersSetup.clientRegisterNetworkReceivers();
            });
        } else {
            LabellingContainers.LOGGER.warn("Could not run Client Setup (mod is probably running on a Server-Only instance)");
        }
    }

    public static void initServer() {
        LabellingContainersSetup.serverRegisterNetworkReceivers();
    }

    public static void serverRegisterNetworkReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)Packets.C2S_REQUEST_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> {
            CompatibleContainers config = (CompatibleContainers)FastConfigs.get(CompatibleContainers.class);
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            Set<String> ids = config.getIds();
            Set<String> tags = config.getTags();
            buffer.writeInt(ids.size());
            ids.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
            buffer.writeInt(tags.size());
            tags.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)context.getPlayer()), (ResourceLocation)Packets.S2C_SYNC_TAGGABLE_BLOCKS_CONFIG, (FriendlyByteBuf)buffer);
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)Packets.C2S_LABEL_PRINTER_SAVE, (buf, context) -> {
            String label = buf.m_130277_();
            ItemStack itemInHand = context.getPlayer().m_21205_();
            if (!itemInHand.m_41619_() && itemInHand.m_150930_((Item)ItemRegistration.LABEL_PRINTER.get())) {
                LabelPrinterItem.setLabel(itemInHand, label);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientRegisterScreens() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenRegistration.LABEL_PRINTER_SCREEN_HANDLER.get()), LabelPrinterGui::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientRegisterEvents() {
        ClientTooltipEvent.ITEM.register(TooltipEventHandler::handle);
        ClientGuiEvent.RENDER_HUD.register((Object)new HudInfoDisplay());
        ClientGuiEvent.RENDER_HUD.register((Object)new LabelPrinterHudInfoDisplay());
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> NetworkManager.sendToServer((ResourceLocation)Packets.C2S_REQUEST_TAGGABLE_BLOCKS_CONFIG, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientRegisterNetworkReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)Packets.S2C_PREFERENCES_CONFIG_UPDATE, (buf, context) -> FastConfigs.editAndSave(PlayerPreferences.class, config -> {
            String ordinalHud = buf.m_130277_();
            config.setHudPosition(HudPositions.fromReadable(ordinalHud));
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)Packets.S2C_SYNC_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> {
            int idsSize = buf.readInt();
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < idsSize; ++i) {
                ids.add(buf.m_130277_());
            }
            int tagsSize = buf.readInt();
            HashSet<String> tags = new HashSet<String>();
            for (int i = 0; i < tagsSize; ++i) {
                tags.add(buf.m_130277_());
            }
            config.setIds(ids);
            config.setTags(tags);
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)Packets.S2C_ADD_ID_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.addId(buf.m_130277_())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)Packets.S2C_REMOVE_ID_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.removeId(buf.m_130277_())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)Packets.S2C_ADD_TAG_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.addTag(buf.m_130277_())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)Packets.S2C_REMOVE_TAG_TAGGABLE_BLOCKS_CONFIG, (buf, context) -> FastConfigs.editAndSave(CompatibleContainers.class, config -> config.removeTag(buf.m_130277_())));
    }
}

