/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.config;

import infinituum.fastconfigapi.api.annotations.FastConfig;
import infinituum.fastconfigapi.api.annotations.Loader;
import infinituum.fastconfigapi.api.serializers.JSONSerializer;
import infinituum.labellingcontainers.registration.registries.ContainerResourceRegistry;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

@FastConfig(subdirectory="labellingcontainers", loader=@Loader(type=Loader.Type.URL, deserializer=JSONSerializer.class, target="https://raw.githubusercontent.com/Infinituum17/LabellingContainers/1.20.1/defaults/configs/compatible-containers.json"))
public final class CompatibleContainers {
    private final boolean limitedContainers = true;
    private Set<String> ids = ContainerResourceRegistry.getIds();
    private Set<String> blockTags = ContainerResourceRegistry.getTags();

    public boolean isLimited() {
        return true;
    }

    public boolean has(String key) {
        return this.ids.contains(key) || this.blockTags.contains(key);
    }

    public boolean hasAnyTag(Stream<TagKey<Block>> tags) {
        return tags.anyMatch(blockTagKey -> this.blockTags.contains(blockTagKey.f_203868_().toString()));
    }

    public void addId(String id) {
        this.ids.add(id);
    }

    public void addTag(String tag) {
        this.blockTags.add(tag);
    }

    public void removeId(String id) {
        this.ids.remove(id);
    }

    public void removeTag(String tag) {
        this.blockTags.remove(tag);
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public void setIds(Set<String> set) {
        this.ids = set;
    }

    public Set<String> getTags() {
        return this.blockTags;
    }

    public void setTags(Set<String> set) {
        this.blockTags = set;
    }
}

