/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.huds.utils;

import infinituum.labellingcontainers.utils.Taggable;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import oshi.util.tuples.Pair;

public enum HudPositions {
    LEFT((width, height, lineHeight, label, labelWidth) -> new Pair((Object)2, (Object)(height / 2 - 8)), (width, height, lineHeight, label, labelWidth) -> new Pair((Object)22, (Object)(height / 2 - lineHeight / 2))),
    CENTER_LEFT((width, height, lineHeight, label, labelWidth) -> new Pair((Object)(width / 2 - 27), (Object)(height / 2 - 8)), (width, height, lineHeight, label, labelWidth) -> new Pair((Object)(width / 2 - labelWidth - 32), (Object)(height / 2 - lineHeight / 2))),
    CENTER_RIGHT((width, height, lineHeight, label, labelWidth) -> new Pair((Object)(width / 2 + 10), (Object)(height / 2 - 8)), (width, height, lineHeight, label, labelWidth) -> new Pair((Object)(width / 2 + 30), (Object)(height / 2 - lineHeight / 2))),
    TOP_LEFT((width, height, lineHeight, label, labelWidth) -> new Pair((Object)2, (Object)2), (width, height, lineHeight, label, labelWidth) -> new Pair((Object)22, (Object)(lineHeight / 2 + 2))),
    TOP((width, height, lineHeight, label, labelWidth) -> new Pair((Object)(width / 2 - (20 + labelWidth) / 2), (Object)2), (width, height, lineHeight, label, labelWidth) -> new Pair((Object)(width / 2 + 20 - (20 + labelWidth) / 2), (Object)(2 + lineHeight / 2)));

    private final ScreenCoordsFunc labelCoordsFunc;
    private final ScreenCoordsFunc itemCoordsFunc;

    private HudPositions(ScreenCoordsFunc itemFunc, ScreenCoordsFunc labelFunc) {
        this.itemCoordsFunc = itemFunc;
        this.labelCoordsFunc = labelFunc;
    }

    public static HudPositions getDefault() {
        return CENTER_RIGHT;
    }

    public static String toReadable(HudPositions position) {
        return switch (position.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "left";
            case 1 -> "center-left";
            case 2 -> "center-right";
            case 3 -> "top-left";
            case 4 -> "top";
        };
    }

    public static HudPositions fromReadable(String readable) {
        return switch (readable) {
            case "left" -> LEFT;
            case "center-left" -> CENTER_LEFT;
            case "center-right" -> CENTER_RIGHT;
            case "top-left" -> TOP_LEFT;
            case "top" -> TOP;
            default -> HudPositions.getDefault();
        };
    }

    public Pair<Integer, Integer> computeLabelCoords(int width, int height, int lineHeight, Component label, int labelWidth) {
        return this.labelCoordsFunc.compute(width, height, lineHeight, label, labelWidth);
    }

    public Pair<Integer, Integer> computeItemCoords(int width, int height, int lineHeight, Component label, int labelWidth) {
        return this.itemCoordsFunc.compute(width, height, lineHeight, label, labelWidth);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(Minecraft client, GuiGraphics graphics, Taggable taggable) {
        if (client.f_91073_ == null) {
            return;
        }
        int width = client.m_91268_().m_85445_();
        int height = client.m_91268_().m_85446_();
        MutableComponent label = taggable.labellingcontainers$getLabel();
        Item displayItem = taggable.labellingcontainers$getDisplayItem();
        int labelWidth = client.f_91062_.m_92852_((FormattedText)label);
        Objects.requireNonNull(client.f_91062_);
        Pair<Integer, Integer> itemCoords = this.computeItemCoords(width, height, 9, (Component)label, labelWidth);
        Objects.requireNonNull(client.f_91062_);
        Pair<Integer, Integer> labelCoords = this.computeLabelCoords(width, height, 9, (Component)label, labelWidth);
        graphics.m_280168_().m_85836_();
        graphics.m_280480_(new ItemStack((ItemLike)displayItem), ((Integer)itemCoords.getA()).intValue(), ((Integer)itemCoords.getB()).intValue());
        graphics.m_280430_(client.f_91062_, (Component)label, ((Integer)labelCoords.getA()).intValue(), ((Integer)labelCoords.getB()).intValue(), -1);
        graphics.m_280168_().m_85849_();
    }

    public static interface ScreenCoordsFunc {
        public Pair<Integer, Integer> compute(int var1, int var2, int var3, Component var4, int var5);
    }
}

