/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.items;

import dev.architectury.registry.menu.MenuRegistry;
import infinituum.fastconfigapi.FastConfigs;
import infinituum.labellingcontainers.config.CompatibleContainers;
import infinituum.labellingcontainers.registration.ItemRegistration;
import infinituum.labellingcontainers.screens.LabelPrinterScreenFactory;
import infinituum.labellingcontainers.utils.ActionBarTextHelper;
import infinituum.labellingcontainers.utils.BlockEntityHelper;
import infinituum.labellingcontainers.utils.InventoryHelper;
import infinituum.labellingcontainers.utils.Taggable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPrinterItem
extends Item {
    public LabelPrinterItem(Item.Properties settings) {
        super(settings);
    }

    public static String getLabel(ItemStack itemStack) {
        CompoundTag labelTag = itemStack.m_41698_("Label");
        if (!labelTag.m_128441_("text")) {
            labelTag.m_128359_("text", "");
        }
        return labelTag.m_128461_("text");
    }

    public static void setLabel(ItemStack itemStack, String text) {
        CompoundTag tag = itemStack.m_41698_("Label");
        tag.m_128359_("text", text);
        itemStack.m_41700_("Label", (Tag)tag);
    }

    public static Item getDisplayItem(ItemStack itemStack) {
        CompoundTag labelTag = itemStack.m_41698_("Label");
        if (!labelTag.m_128441_("displayItem")) {
            labelTag.m_128365_("displayItem", (Tag)ItemStack.f_41583_.m_41739_(new CompoundTag()));
        }
        return ItemStack.m_41712_((CompoundTag)labelTag.m_128469_("displayItem")).m_41720_();
    }

    public static void setDisplayItem(ItemStack itemStack, ItemStack itemToDisplay) {
        CompoundTag tag = itemStack.m_41698_("Label");
        tag.m_128365_("displayItem", (Tag)itemToDisplay.m_41739_(new CompoundTag()));
        itemStack.m_41700_("Label", (Tag)tag);
    }

    public static int getModeIndex(ItemStack itemStack) {
        CompoundTag labelTag = itemStack.m_41698_("Label");
        if (!labelTag.m_128441_("modeIndex")) {
            labelTag.m_128405_("modeIndex", 0);
        }
        return labelTag.m_128451_("modeIndex");
    }

    public static LabelPrinterMode getMode(ItemStack itemStack) {
        int i = LabelPrinterItem.getModeIndex(itemStack);
        return LabelPrinterMode.fromIndex(i);
    }

    public static void setModeIndex(ItemStack itemStack, int modeIndex) {
        CompoundTag tag = itemStack.m_41698_("Label");
        tag.m_128405_("modeIndex", modeIndex);
        itemStack.m_41700_("Label", (Tag)tag);
    }

    public static void setMode(ItemStack itemStack, LabelPrinterMode mode) {
        int i = mode.ordinal();
        LabelPrinterItem.setModeIndex(itemStack, i);
    }

    private InteractionResult interactionFail(Level level, Vec3 hitPos, BlockPos pos) {
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123762_, hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), 15, 0.0, 0.0, 0.0, 0.01);
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.75f, 2.0f);
        return InteractionResult.FAIL;
    }

    private InteractionResult interactionFail(Level level, Vec3 hitPos, BlockPos pos, Player player, String errorTranslationKey) {
        ActionBarTextHelper.sendMessage((ServerPlayer)player, (Component)Component.m_237115_((String)(((Item)ItemRegistration.LABEL_PRINTER.get()).m_5524_() + errorTranslationKey)).m_130940_(ChatFormatting.RED));
        return this.interactionFail(level, hitPos, pos);
    }

    private InteractionResult interactionSuccess(Level level, Vec3 hitPos, BlockPos pos) {
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123810_, hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), 15, 0.0, 0.0, 0.0, 0.01);
        level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12214_.m_203334_(), SoundSource.BLOCKS, 0.75f, 2.0f);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult interactionSuccess(Level level, Vec3 hitPos, BlockPos pos, Player player, String successTranslationKey) {
        ActionBarTextHelper.sendMessage((ServerPlayer)player, (Component)Component.m_237115_((String)(((Item)ItemRegistration.LABEL_PRINTER.get()).m_5524_() + successTranslationKey)).m_130940_(ChatFormatting.GOLD));
        return this.interactionSuccess(level, hitPos, pos);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Inventory inventory = player.m_150109_();
        BlockPos clickedBlockPosition = context.m_8083_();
        ItemStack itemInHand = context.m_43722_();
        BlockState blockState = level.m_8055_(clickedBlockPosition);
        ResourceLocation registryName = blockState.m_60734_().m_5456_().arch$registryName();
        Vec3 hitPosVec3 = context.m_43720_();
        if (registryName == null) {
            return super.m_6225_(context);
        }
        BlockEntity blockEntity = BlockEntityHelper.locateTargetBlockEntity(level, clickedBlockPosition, blockState);
        if (!(blockEntity instanceof Taggable)) {
            if (player.m_6047_()) {
                this.swapMode(itemInHand);
            } else {
                MenuRegistry.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new LabelPrinterScreenFactory());
            }
            return InteractionResult.SUCCESS;
        }
        Taggable taggable = (Taggable)blockEntity;
        MutableComponent printerLabel = Component.m_237113_((String)LabelPrinterItem.getLabel(itemInHand));
        Item printerDisplayItem = LabelPrinterItem.getDisplayItem(itemInHand);
        MutableComponent blockLabel = taggable.labellingcontainers$getLabel();
        Item blockDisplayItem = taggable.labellingcontainers$getDisplayItem();
        CompatibleContainers config = (CompatibleContainers)FastConfigs.get(CompatibleContainers.class);
        boolean dataIsEqual = blockLabel.equals((Object)printerLabel) && blockDisplayItem.equals(printerDisplayItem);
        switch (LabelPrinterItem.getMode(itemInHand).ordinal()) {
            case 0: {
                if (config.isLimited() && !config.has(registryName.toString()) && !config.hasAnyTag(blockState.m_204343_())) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition, player, ".untaggable.error");
                }
                if (!inventory.m_36063_(Items.f_42516_.m_7968_()) && !player.m_7500_()) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition, player, ".paper.error");
                }
                if (dataIsEqual) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition);
                }
                if (!player.m_7500_()) {
                    InventoryHelper.removeOneItemFromInventory(inventory, Items.f_42516_);
                }
                taggable.labellingcontainers$setLabel(printerLabel, true);
                taggable.labellingcontainers$setDisplayItem(printerDisplayItem, true);
                return this.interactionSuccess(level, hitPosVec3, clickedBlockPosition);
            }
            case 1: {
                if (config.isLimited() && !config.has(registryName.toString()) && !config.hasAnyTag(blockState.m_204343_())) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition, player, ".mode.copy.error");
                }
                if (dataIsEqual) {
                    return this.interactionFail(level, hitPosVec3, clickedBlockPosition);
                }
                LabelPrinterItem.setLabel(itemInHand, blockLabel.getString());
                LabelPrinterItem.setDisplayItem(itemInHand, blockDisplayItem.m_7968_());
                return this.interactionSuccess(level, hitPosVec3, clickedBlockPosition, player, ".mode.copy.success");
            }
        }
        return super.m_6225_(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.m_5776_()) {
            return super.m_7203_(level, player, hand);
        }
        if (hand == InteractionHand.MAIN_HAND) {
            if (player.m_6047_()) {
                this.swapMode(player.m_21120_(hand));
            } else {
                MenuRegistry.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new LabelPrinterScreenFactory());
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag context) {
        String currentLabel = LabelPrinterItem.getLabel(stack);
        Item currentDisplayItem = LabelPrinterItem.getDisplayItem(stack);
        int currentModeIndex = LabelPrinterItem.getModeIndex(stack);
        MutableComponent descriptionText = Component.m_237113_((String)"\u24d8 ").m_130940_(ChatFormatting.BLUE);
        if (level != null && level.m_5776_() && Screen.m_96638_()) {
            descriptionText.m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.description")).m_130940_(ChatFormatting.GREEN));
        } else {
            descriptionText.m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.hidden")).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)descriptionText);
        tooltip.add((Component)Component.m_237113_((String)""));
        MutableComponent labelText = Component.m_237113_((String)"\u25cf ").m_130940_(ChatFormatting.GRAY);
        labelText.m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.label")).m_130940_(ChatFormatting.GRAY));
        if (currentLabel.isEmpty()) {
            labelText.m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.none")).m_130940_(ChatFormatting.DARK_RED));
        } else {
            labelText.m_7220_((Component)Component.m_237113_((String)("\"" + currentLabel + "\"")).m_130940_(ChatFormatting.GOLD));
        }
        tooltip.add((Component)labelText);
        MutableComponent displayItemText = Component.m_237113_((String)"\u25cf ").m_130940_(ChatFormatting.GRAY);
        displayItemText.m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.display_item")).m_130940_(ChatFormatting.GRAY));
        if (currentDisplayItem.equals(Items.f_41852_)) {
            displayItemText.m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.none")).m_130940_(ChatFormatting.DARK_RED));
        } else {
            displayItemText.m_7220_((Component)currentDisplayItem.m_41466_().m_6881_().m_130940_(ChatFormatting.AQUA));
        }
        tooltip.add((Component)displayItemText);
        MutableComponent modeText = Component.m_237113_((String)"\u25cf ").m_130940_(ChatFormatting.GRAY);
        modeText.m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.mode")).m_130940_(ChatFormatting.GRAY));
        modeText.m_7220_(LabelPrinterMode.fromIndex(currentModeIndex).getDisplayable());
        tooltip.add((Component)modeText);
        super.m_7373_(stack, level, tooltip, context);
    }

    private void swapMode(ItemStack currentItemStack) {
        LabelPrinterMode mode = LabelPrinterItem.getMode(currentItemStack);
        LabelPrinterItem.setMode(currentItemStack, mode.swap());
    }

    public static enum LabelPrinterMode {
        CREATE((Component)Component.m_237115_((String)"item.labellingcontainers.label_printer.mode.create").m_130940_(ChatFormatting.RED)),
        COPY((Component)Component.m_237115_((String)"item.labellingcontainers.label_printer.mode.copy").m_130940_(ChatFormatting.GOLD));

        private final Component name;

        private LabelPrinterMode(Component s) {
            this.name = s;
        }

        public static LabelPrinterMode fromIndex(int index) {
            return LabelPrinterMode.values()[index];
        }

        public Component getDisplayable() {
            return this.name;
        }

        public LabelPrinterMode swap() {
            if (this == CREATE) {
                return COPY;
            }
            return CREATE;
        }
    }
}

