/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.registration;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.networking.NetworkManager;
import infinituum.fastconfigapi.FastConfigs;
import infinituum.fastconfigapi.api.FastConfigFile;
import infinituum.labellingcontainers.config.CompatibleContainers;
import infinituum.labellingcontainers.huds.utils.HudPositions;
import infinituum.labellingcontainers.network.Packets;
import infinituum.labellingcontainers.utils.Taggable;
import io.netty.buffer.Unpooled;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class CommandRegistration {
    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setlabel").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82127_((String)"label").then(Commands.m_82129_((String)"label", (ArgumentType)MessageArgument.m_96832_()).executes(context -> {
                BlockPos pos = Vec3Argument.m_120849_((CommandContext)context, (String)"location").m_119568_((CommandSourceStack)context.getSource());
                MutableComponent label = MessageArgument.m_96835_((CommandContext)context, (String)"label").m_6881_();
                ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
                BlockEntity be = level.m_7702_(pos);
                if (be instanceof Taggable) {
                    Taggable labelable = (Taggable)be;
                    labelable.labellingcontainers$setLabel(label, true);
                }
                return 1;
            })))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setlabel").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82127_((String)"item").then(Commands.m_82129_((String)"display-item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).executes(context -> {
                BlockPos pos = Vec3Argument.m_120849_((CommandContext)context, (String)"location").m_119568_((CommandSourceStack)context.getSource());
                Item item = ItemArgument.m_120963_((CommandContext)context, (String)"display-item").m_120979_();
                ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
                BlockEntity be = level.m_7702_(pos);
                if (be instanceof Taggable) {
                    Taggable labelable = (Taggable)be;
                    labelable.labellingcontainers$setDisplayItem(item, true);
                }
                return 1;
            })))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add-hand").requires(CommandSourceStack::m_230897_)).executes(context -> {
                CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
                if (commandContext == null) {
                    return 0;
                }
                ServerPlayer player = commandContext.m_230896_();
                if (player == null) {
                    return 0;
                }
                Item item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                ResourceLocation resourceLocation = item.arch$registryName();
                return CommandRegistration.addId((CommandContext<CommandSourceStack>)context, resourceLocation);
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove-hand").requires(CommandSourceStack::m_230897_)).executes(context -> {
                CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
                if (commandContext == null) {
                    return 0;
                }
                ServerPlayer player = commandContext.m_230896_();
                if (player == null) {
                    return 0;
                }
                Item item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                ResourceLocation resourceLocation = item.arch$registryName();
                return CommandRegistration.removeId((CommandContext<CommandSourceStack>)context, resourceLocation);
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"add-item").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).executes(context -> {
                CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
                Item item = ItemArgument.m_120963_((CommandContext)context, (String)"item").m_120979_();
                if (commandContext == null) {
                    return 0;
                }
                ServerPlayer player = commandContext.m_230896_();
                if (player == null) {
                    return 0;
                }
                ResourceLocation resourceLocation = item.arch$registryName();
                return CommandRegistration.addId((CommandContext<CommandSourceStack>)context, resourceLocation);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"remove-item").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).executes(context -> {
                CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
                Item item = ItemArgument.m_120963_((CommandContext)context, (String)"item").m_120979_();
                if (commandContext == null) {
                    return 0;
                }
                ServerPlayer player = commandContext.m_230896_();
                if (player == null) {
                    return 0;
                }
                ResourceLocation resourceLocation = item.arch$registryName();
                return CommandRegistration.removeId((CommandContext<CommandSourceStack>)context, resourceLocation);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"add-tag").then(Commands.m_82129_((String)"tag", (ArgumentType)MessageArgument.m_96832_()).executes(context -> {
                CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
                String tag = MessageArgument.m_96835_((CommandContext)context, (String)"tag").getString();
                if (commandContext == null) {
                    return 0;
                }
                ServerPlayer player = commandContext.m_230896_();
                if (player == null) {
                    return 0;
                }
                return CommandRegistration.addTag((CommandContext<CommandSourceStack>)context, tag);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelconfig").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"remove-tag").then(Commands.m_82129_((String)"item", (ArgumentType)MessageArgument.m_96832_()).executes(context -> {
                CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
                String tag = MessageArgument.m_96835_((CommandContext)context, (String)"item").getString();
                if (commandContext == null) {
                    return 0;
                }
                ServerPlayer player = commandContext.m_230896_();
                if (player == null) {
                    return 0;
                }
                return CommandRegistration.removeTag((CommandContext<CommandSourceStack>)context, tag);
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelposition").requires(CommandSourceStack::m_230897_)).then(Commands.m_82127_((String)"top").executes(context -> CommandRegistration.setLabelPosition((CommandContext<CommandSourceStack>)context, HudPositions.TOP))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelposition").requires(CommandSourceStack::m_230897_)).then(Commands.m_82127_((String)"top-left").executes(context -> CommandRegistration.setLabelPosition((CommandContext<CommandSourceStack>)context, HudPositions.TOP_LEFT))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelposition").requires(CommandSourceStack::m_230897_)).then(Commands.m_82127_((String)"center-left").executes(context -> CommandRegistration.setLabelPosition((CommandContext<CommandSourceStack>)context, HudPositions.CENTER_LEFT))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelposition").requires(CommandSourceStack::m_230897_)).then(Commands.m_82127_((String)"center-right").executes(context -> CommandRegistration.setLabelPosition((CommandContext<CommandSourceStack>)context, HudPositions.CENTER_RIGHT))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labelposition").requires(CommandSourceStack::m_230897_)).then(Commands.m_82127_((String)"left").executes(context -> CommandRegistration.setLabelPosition((CommandContext<CommandSourceStack>)context, HudPositions.LEFT))));
        });
    }

    private static int setLabelPosition(CommandContext<CommandSourceStack> context, HudPositions position) {
        CommandSourceStack sourceStack = (CommandSourceStack)context.getSource();
        ServerPlayer player = sourceStack.m_230896_();
        if (player == null) {
            return 0;
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130070_(HudPositions.toReadable(position));
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)Packets.S2C_PREFERENCES_CONFIG_UPDATE, (FriendlyByteBuf)buffer);
        return 1;
    }

    private static int addId(CommandContext<CommandSourceStack> context, ResourceLocation resourceLocation) {
        CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        ServerPlayer player = commandContext.m_230896_();
        if (player == null || resourceLocation == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (config.has(resourceLocation.toString())) {
            return 0;
        }
        config.addId(resourceLocation.toString());
        configFile.save();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130070_(resourceLocation.toString());
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)Packets.S2C_ADD_ID_TAGGABLE_BLOCKS_CONFIG, (FriendlyByteBuf)buffer);
        player.m_213846_((Component)Component.m_237110_((String)"command.labelconfig.addition.success", (Object[])new Object[]{resourceLocation.toString()}));
        return 1;
    }

    private static int removeId(CommandContext<CommandSourceStack> context, ResourceLocation resourceLocation) {
        CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        ServerPlayer player = commandContext.m_230896_();
        if (player == null || resourceLocation == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (!config.has(resourceLocation.toString())) {
            return 0;
        }
        config.removeId(resourceLocation.toString());
        configFile.save();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130070_(resourceLocation.toString());
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)Packets.S2C_REMOVE_ID_TAGGABLE_BLOCKS_CONFIG, (FriendlyByteBuf)buffer);
        player.m_213846_((Component)Component.m_237110_((String)"command.labelconfig.removal.success", (Object[])new Object[]{resourceLocation.toString()}));
        return 1;
    }

    private static int addTag(CommandContext<CommandSourceStack> context, String tag) {
        CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        ServerPlayer player = commandContext.m_230896_();
        if (player == null || tag == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (config.has(tag)) {
            return 0;
        }
        config.addTag(tag);
        configFile.save();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130070_(tag);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)Packets.S2C_ADD_TAG_TAGGABLE_BLOCKS_CONFIG, (FriendlyByteBuf)buffer);
        player.m_213846_((Component)Component.m_237110_((String)"command.labelconfig.addition.success", (Object[])new Object[]{tag}));
        return 1;
    }

    private static int removeTag(CommandContext<CommandSourceStack> context, String tag) {
        CommandSourceStack commandContext = (CommandSourceStack)context.getSource();
        if (commandContext == null) {
            return 0;
        }
        ServerPlayer player = commandContext.m_230896_();
        if (player == null || tag == null) {
            return 0;
        }
        FastConfigFile configFile = FastConfigs.getFile(CompatibleContainers.class);
        CompatibleContainers config = (CompatibleContainers)configFile.getInstance();
        if (!config.has(tag)) {
            return 0;
        }
        config.removeTag(tag);
        configFile.save();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130070_(tag);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)Packets.S2C_REMOVE_TAG_TAGGABLE_BLOCKS_CONFIG, (FriendlyByteBuf)buffer);
        player.m_213846_((Component)Component.m_237110_((String)"command.labelconfig.removal.success", (Object[])new Object[]{tag}));
        return 1;
    }
}

