/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.utils;

import infinituum.labellingcontainers.PlatformHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class BlockEntityHelper {
    public static BlockEntity locateTargetBlockEntity(@NotNull Level level, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof AbstractChestBlock) {
            return BlockEntityHelper.getConnectedChest(level, pos, state);
        }
        return PlatformHelper.locateTargetBlockEntity(level, pos, state);
    }

    public static BlockEntity getConnectedChest(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        Optional optType = state.m_61145_((Property)ChestBlock.f_51479_);
        if (optType.isEmpty()) {
            return level.m_7702_(pos);
        }
        ChestType chestType = (ChestType)optType.get();
        if (chestType == ChestType.SINGLE) {
            return level.m_7702_(pos);
        }
        Direction facingDirection = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
        BlockPos neighbourPosition = pos.m_121945_(chestType == ChestType.LEFT ? facingDirection.m_122427_() : facingDirection.m_122428_());
        if (level.m_7702_(neighbourPosition) != null && (blockEntity = level.m_7702_(neighbourPosition)) instanceof ChestBlockEntity) {
            ChestBlockEntity blockEntity2 = (ChestBlockEntity)blockEntity;
            return blockEntity2;
        }
        return level.m_7702_(pos);
    }

    public static interface BlockEntityLocatorHandler {
        public static BlockEntity handle(Level level, BlockPos blockPos, BlockState blockState) {
            return level.m_7702_(blockPos);
        }
    }
}

