/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.config;

import infinituum.fastconfigapi.api.annotations.FastConfig;
import infinituum.fastconfigapi.api.annotations.Loader;
import infinituum.fastconfigapi.api.serializers.JSONSerializer;
import infinituum.labellingcontainers.registration.registries.ContainerResourceRegistry;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_6862;

@FastConfig(subdirectory="labellingcontainers", side=FastConfig.Side.COMMON, loader=@Loader(type=Loader.Type.URL, target="https://raw.githubusercontent.com/Infinituum17/LabellingContainers/refs/heads/main/defaults/config/compatible-containers.json", deserializer=JSONSerializer.class))
public final class CompatibleContainers {
    private final boolean limitedContainers = true;
    private Set<String> ids = ContainerResourceRegistry.getIds();
    private Set<String> blockTags = ContainerResourceRegistry.getTags();

    public boolean isLimited() {
        return true;
    }

    public boolean has(String key) {
        return this.ids.contains(key) || this.blockTags.contains(key);
    }

    public boolean hasAnyTag(Stream<class_6862<class_2248>> tags) {
        return tags.anyMatch(blockTagKey -> this.blockTags.contains(blockTagKey.comp_327().toString()));
    }

    public void addId(String id) {
        this.ids.add(id);
    }

    public void addTag(String tag) {
        this.blockTags.add(tag);
    }

    public void removeId(String id) {
        this.ids.remove(id);
    }

    public void removeTag(String tag) {
        this.blockTags.remove(tag);
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public void setIds(Set<String> set) {
        this.ids = set;
    }

    public Set<String> getTags() {
        return this.blockTags;
    }

    public void setTags(Set<String> set) {
        this.blockTags = set;
    }
}

