/*
 * Decompiled with CFR 0.152.
 */
package infinituum.labellingcontainers.network.packets.s2c;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import infinituum.fastconfigapi.FastConfigs;
import infinituum.labellingcontainers.config.CompatibleContainers;
import infinituum.labellingcontainers.utils.CommonHelper;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public final class SyncConfigPacket
implements class_8710 {
    public static final class_9139<ByteBuf, SyncConfigPacket> CODEC = class_9139.method_56437(SyncConfigPacket::encode, SyncConfigPacket::new);
    public static final class_8710.class_9154<SyncConfigPacket> PACKET_TYPE = new class_8710.class_9154(CommonHelper.id("sync_taggable_blocks_config_packet"));
    private final Set<String> ids;
    private final Set<String> tags;

    public SyncConfigPacket(ByteBuf byteBuf) {
        class_2540 buf = new class_2540(byteBuf);
        this.ids = new HashSet<String>();
        this.tags = new HashSet<String>();
        int idsSize = buf.readInt();
        for (int i = 0; i < idsSize; ++i) {
            this.ids.add(buf.method_19772());
        }
        int tagsSize = buf.readInt();
        for (int i = 0; i < tagsSize; ++i) {
            this.tags.add(buf.method_19772());
        }
    }

    public SyncConfigPacket(Set<String> ids, Set<String> tags) {
        this.ids = ids;
        this.tags = tags;
    }

    private static void encode(ByteBuf byteBuf, SyncConfigPacket packet) {
        class_2540 buf = new class_2540(byteBuf);
        buf.method_53002(packet.ids.size());
        packet.ids.forEach(arg_0 -> ((class_2540)buf).method_10814(arg_0));
        buf.method_53002(packet.tags.size());
        packet.tags.forEach(arg_0 -> ((class_2540)buf).method_10814(arg_0));
    }

    public static void register() {
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), PACKET_TYPE, CODEC, SyncConfigPacket::handler);
        } else {
            NetworkManager.registerS2CPayloadType(PACKET_TYPE, CODEC);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void handler(NetworkManager.PacketContext packetContext) {
        CompatibleContainers config = (CompatibleContainers)FastConfigs.get(CompatibleContainers.class);
        config.setIds(this.ids);
        config.setTags(this.tags);
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_TYPE;
    }
}

