/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import settingdust.mod_sets.ModSets;
import settingdust.mod_sets.data.ModSetsDisabledMods;
import settingdust.mod_sets.util.LoaderAdapter;
import settingdust.preloading_tricks.api.PreloadingEntrypoint;
import settingdust.preloading_tricks.api.PreloadingTricksCallbacks;

public class ModSetsPreloadingEntrypoint
implements PreloadingEntrypoint {
    public static final Logger LOGGER = LogManager.getLogger();

    public ModSetsPreloadingEntrypoint() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ModSets.class.getClassLoader());
        ModSets.load();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        PreloadingTricksCallbacks.COLLECT_MOD_CANDIDATES.register(manager -> {
            try {
                ArrayList subDirectories = Lists.newArrayList(Files.newDirectoryStream(LoaderAdapter.get().getModsDirectory(), x$0 -> Files.isDirectory(x$0, new LinkOption[0])));
                LOGGER.info("Loading mods from {} sub-folders in 'mods' folder", (Object)subDirectories.size());
                LOGGER.debug(String.join((CharSequence)", ", Lists.transform((List)subDirectories, it -> it.getFileName().toString())));
                manager.addAll(subDirectories.stream().flatMap(it -> {
                    try {
                        return Streams.stream(Files.newDirectoryStream(it, "*.jar"));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        PreloadingTricksCallbacks.SETUP_MODS.register(manager -> manager.removeByIds(ModSetsDisabledMods.disabledMods()));
    }
}

