/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets.game;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FilenameUtils;
import settingdust.mod_sets.ModSets;
import settingdust.mod_sets.game.data.ControllerRegistrar;
import settingdust.mod_sets.game.data.ModSet;
import settingdust.mod_sets.game.data.RuleSet;
import settingdust.mod_sets.game.util.ComponentAdapter;
import settingdust.mod_sets.game.util.ModSetLoadCallback;
import settingdust.mod_sets.util.LoaderAdapter;
import settingdust.mod_sets.util.SavingData;

public class ModSetsIngameConfig
implements SavingData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Component.class, ComponentAdapter.get().getTypeAdapter()).registerTypeAdapterFactory(ControllerRegistrar.SERIALIZER).create();
    private static final Path modSetsPath = LoaderAdapter.get().getConfigDirectory().resolve("modsets.json");
    private static final Path rulesPath = LoaderAdapter.get().getConfigDirectory().resolve("rules");
    private static Map<String, ModSet> modSets = new HashMap<String, ModSet>();
    private static Multimap<String, ModSet> modSetsByMod = HashMultimap.create();
    private static Map<String, ModSet> definedModSets = new HashMap<String, ModSet>();
    private static Map<String, RuleSet> rules = new HashMap<String, RuleSet>();

    public static Map<String, ModSet> modSets() {
        return modSets;
    }

    public static Map<String, RuleSet> rules() {
        return rules;
    }

    public static Multimap<String, ModSet> modSetsByMod() {
        return modSetsByMod;
    }

    public static ModSet getModSetOrThrow(String name) {
        ModSet result = modSets.get(name);
        if (result == null) {
            throw new IllegalArgumentException("No mod set named " + name);
        }
        return result;
    }

    public void load() {
        try {
            Files.createDirectories(modSetsPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.createFile(modSetsPath, new FileAttribute[0]);
            Files.writeString(modSetsPath, (CharSequence)"{}", new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            definedModSets = (Map)GSON.fromJson((Reader)Files.newBufferedReader(modSetsPath), TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, ModSet.class}));
        }
        catch (IOException e) {
            ModSets.LOGGER.error("Fail to load mod sets", (Throwable)e);
        }
        modSets.clear();
        modSets.putAll(definedModSets);
        ((ModSetLoadCallback.Callback)ModSetLoadCallback.EVENT.getInvoker()).onLoad();
        modSetsByMod.clear();
        for (Map.Entry<String, ModSet> entry : modSets.entrySet()) {
            ModSet modSet = entry.getValue();
            for (String mod : modSet.mods()) {
                modSetsByMod.put((Object)mod, (Object)modSet);
            }
        }
        try {
            Files.createDirectories(rulesPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            for (Path rulePath : Files.newDirectoryStream(rulesPath, "*.json")) {
                try {
                    RuleSet rule = (RuleSet)GSON.fromJson((Reader)Files.newBufferedReader(rulePath), TypeToken.get(RuleSet.class));
                    rules.put(FilenameUtils.getBaseName((String)rulePath.getFileName().toString()), rule);
                }
                catch (IOException e) {
                    ModSets.LOGGER.error("Fail to load rule {}", (Object)rulePath.getFileName(), (Object)e);
                }
            }
        }
        catch (IOException e) {
            ModSets.LOGGER.error("Fail to load rules", (Throwable)e);
        }
    }

    public void save() {
    }
}

