/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets.game.data.controller;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionAddable;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import settingdust.mod_sets.game.ModSetsIngameConfig;
import settingdust.mod_sets.game.data.ControllerRegistrar;
import settingdust.mod_sets.game.data.ModSet;
import settingdust.mod_sets.game.data.Rule;
import settingdust.mod_sets.game.data.controller.BooleanControllerRegistrar;
import settingdust.mod_sets.game.data.controller.LabelControllerRegistrar;

public class ModsGroupControllerRegistrar
implements ControllerRegistrar {
    private final List<String> ids;
    private boolean collapsed = true;
    private boolean showMods = true;

    public ModsGroupControllerRegistrar(List<String> ids, boolean collapsed, boolean showMods) {
        this.ids = ids;
        this.collapsed = collapsed;
        this.showMods = showMods;
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("ModsGroupControllerRegistrar must have at least one mod");
        }
    }

    public ModsGroupControllerRegistrar(List<String> ids) {
        this.ids = ids;
    }

    private static Option.Builder<Boolean> modSetToOption(String id, ModSet modSet) {
        Option.Builder builder = Option.createBuilder().name(modSet.text()).controller(TickBoxControllerBuilder::create).stateManager(StateManager.createInstant(BooleanControllerRegistrar.createBooleanBinding(id)));
        Component description = modSet.description();
        if (description != null) {
            builder.description(OptionDescription.of((Component[])new Component[]{description}));
        }
        return builder;
    }

    @Override
    public void registerCategory(ConfigCategory.Builder category, Rule rule) {
        OptionGroup.Builder builder = OptionGroup.createBuilder();
        builder.name(rule.text()).collapsed(this.collapsed);
        Component description = rule.description();
        if (description != null) {
            builder.description(OptionDescription.of((Component[])new Component[]{description}));
        }
        this.registerRule((OptionAddable)builder, rule);
        category.group(builder.build());
    }

    @Override
    public void registerGroup(OptionGroup.Builder group, Rule rule) {
        LabelControllerRegistrar.INSTANCE.registerRule((OptionAddable)group, rule);
        ControllerRegistrar.super.registerGroup(group, rule);
    }

    @Override
    public void registerRule(OptionAddable owner, Rule rule) {
        for (String id : this.ids) {
            ModSet modSet = ModSetsIngameConfig.modSets().get(id);
            if (modSet == null) continue;
            owner.option(ModsGroupControllerRegistrar.modSetToOption(id, modSet).build());
            if (!this.showMods) continue;
            for (String nestedId : modSet.mods()) {
                ModSet nestedModSet;
                if (nestedId.equals(id) || (nestedModSet = ModSetsIngameConfig.modSets().get(nestedId)) == null) continue;
                owner.option(ModsGroupControllerRegistrar.modSetToOption(nestedId, nestedModSet).build());
            }
        }
    }
}

