/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets.neoforge.game;

import com.google.common.collect.Sets;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import settingdust.mod_sets.ModSets;
import settingdust.mod_sets.data.ModSetsDisabledMods;
import settingdust.mod_sets.game.ModSetsConfigScreenGenerator;
import settingdust.mod_sets.game.ModSetsIngameConfig;
import settingdust.mod_sets.game.data.ModSet;
import settingdust.mod_sets.game.util.ModSetLoadCallback;

@Mod(value="mod_sets")
public class ModSetsNeoForge {
    public ModSetsNeoForge(IEventBus modBus) {
        modBus.addListener(event -> {
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (modContainer, parent) -> ModSetsConfigScreenGenerator.generateScreen(parent));
            Map<String, ModSet> modSets = ModSetsIngameConfig.modSets();
            ModSetLoadCallback.EVENT.register(() -> {
                for (Object mod : ModList.get().getMods()) {
                    String modId = mod.getModId();
                    if (modSets.containsKey(modId)) {
                        ModSets.LOGGER.warn("Duplicated mod set with mod id: {}", (Object)modId);
                        continue;
                    }
                    modSets.put(modId, new ModSet((Component)Component.literal((String)modId), (Component)Component.literal((String)(mod.getDisplayName() + " " + modId + "@" + String.valueOf(mod.getVersion()))), Sets.newHashSet((Object[])new String[]{modId})));
                }
                for (Object mod : ModSetsDisabledMods.disablingMods()) {
                    if (modSets.containsKey(mod)) continue;
                    modSets.put((String)mod, new ModSet((Component)Component.literal((String)mod), (Component)Component.literal((String)((String)mod + "@disabled")), Sets.newHashSet((Object[])new String[]{mod})));
                }
            });
        });
    }
}

