/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets.data;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import settingdust.mod_sets.util.LoaderAdapter;
import settingdust.mod_sets.util.SavingData;

public class ModSetsDisabledMods
implements SavingData {
    private static final Path configPath = LoaderAdapter.get().getConfigDirectory().resolve("disabled_mods.json");
    private static Set<String> disabledMods = null;
    private static Set<String> disablingMods = null;

    public static Set<String> disabledMods() {
        return disabledMods;
    }

    public static Set<String> disablingMods() {
        return disablingMods;
    }

    @Override
    public void load() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.createFile(configPath, new FileAttribute[0]);
            Files.writeString(configPath, (CharSequence)"[]", new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            disabledMods = (Set)GSON.fromJson(Files.readString(configPath), TypeToken.getParameterized(Set.class, (Type[])new Type[]{String.class}));
            if (disabledMods == null) {
                disabledMods = new HashSet<String>();
            }
            if (disablingMods == null) {
                disablingMods = disabledMods;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to load disabled mods", e);
        }
        this.save();
    }

    @Override
    public void save() {
        try {
            GSON.toJson(disabledMods, (Appendable)Files.newBufferedWriter(configPath, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to save disabled mods", e);
        }
    }
}

