/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets.forge.game;

import com.google.common.collect.Sets;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModsFolderLocator;
import net.minecraftforge.forgespi.locating.IModProvider;
import settingdust.mod_sets.ModSets;
import settingdust.mod_sets.data.ModSetsDisabledMods;
import settingdust.mod_sets.game.ModSetsConfigScreenGenerator;
import settingdust.mod_sets.game.ModSetsIngameConfig;
import settingdust.mod_sets.game.data.ModSet;
import settingdust.mod_sets.game.util.ModSetLoadCallback;
import settingdust.preloading_tricks.lexforge.mod_candidate.DefinedModLocator;

@Mod(value="mod_sets")
public class ModSetsForge {
    public ModSetsForge() {
        FMLJavaModLoadingContext loadingContext = FMLJavaModLoadingContext.get();
        IEventBus modBus = loadingContext.getModEventBus();
        modBus.addListener(event -> {
            loadingContext.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> ModSetsConfigScreenGenerator.generateScreen(parent)));
            Map<String, ModSet> modSets = ModSetsIngameConfig.modSets();
            ModSetLoadCallback.EVENT.register(() -> {
                for (Object mod : ModList.get().getMods()) {
                    IModProvider provider = mod.getOwningFile().getFile().getProvider();
                    if (!(provider instanceof ModsFolderLocator) && !(provider instanceof DefinedModLocator)) continue;
                    String modId = mod.getModId();
                    if (modSets.containsKey(modId)) {
                        ModSets.LOGGER.warn("Duplicated mod set with mod id: {}", (Object)modId);
                        continue;
                    }
                    modSets.put(modId, new ModSet((Component)Component.m_237113_((String)modId), (Component)Component.m_237113_((String)(mod.getDisplayName() + " " + modId + "@" + String.valueOf(mod.getVersion()))), Sets.newHashSet((Object[])new String[]{modId})));
                }
                for (Object mod : ModSetsDisabledMods.disablingMods()) {
                    if (modSets.containsKey(mod)) continue;
                    modSets.put((String)mod, new ModSet((Component)Component.m_237113_((String)mod), (Component)Component.m_237113_((String)((String)mod + "@disabled")), Sets.newHashSet((Object[])new String[]{mod})));
                }
            });
        });
    }
}

