/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets.game;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import settingdust.mod_sets.ModSets;
import settingdust.mod_sets.game.ModSetsConfigScreen;
import settingdust.mod_sets.game.ModSetsIngameConfig;
import settingdust.mod_sets.game.data.Rule;
import settingdust.mod_sets.game.data.RuleSet;

public class ModSetsConfigScreenGenerator {
    private static void save() {
        ModSets.save();
    }

    public static YetAnotherConfigLib generate() {
        ModSets.load();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((Component)Component.translatable((String)"modsets.name")).save(ModSetsConfigScreenGenerator::save);
        boolean noRule = ModSetsIngameConfig.rules().isEmpty();
        if (noRule) {
            builder.category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"modsets.no_rules")).build());
            return builder.build();
        }
        HashSet options = new HashSet();
        for (Map.Entry<String, RuleSet> ruleSetEntry : ModSetsIngameConfig.rules().entrySet()) {
            RuleSet ruleSet = ruleSetEntry.getValue();
            ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder().name(ruleSet.text());
            Component description = ruleSet.description();
            if (description != null) {
                categoryBuilder.tooltip(new Component[]{description});
            }
            for (Rule rule : ruleSet.rules()) {
                rule.controller().registerCategory(categoryBuilder, rule);
            }
            ConfigCategory category = categoryBuilder.build();
            for (OptionGroup group : category.groups()) {
                options.addAll(group.options());
            }
            builder.category(category);
        }
        for (Option option : options) {
            option.addEventListener((currentOption, event) -> {
                boolean changed = false;
                for (Option anotherOption : options) {
                    if (anotherOption == currentOption || !anotherOption.changed()) continue;
                    anotherOption.requestSet(anotherOption.stateManager().get());
                    if (changed || !currentOption.changed()) continue;
                    changed = true;
                    ModSets.LOGGER.warn("Option {} change is conflicting with option {}. Can't apply.", (Object)currentOption.name(), (Object)anotherOption.name());
                }
                if (currentOption.changed()) {
                    ModSets.LOGGER.warn("Option {} change is conflicting with unknown option. Can't apply.", (Object)currentOption.name());
                    currentOption.requestSet(currentOption.stateManager().get());
                }
                ModSetsConfigScreenGenerator.save();
            });
        }
        return builder.build();
    }

    public static Screen generateScreen(Screen parent) {
        return new ModSetsConfigScreen(parent);
    }
}

