/*
 * Decompiled with CFR 0.152.
 */
package settingdust.mod_sets.game.data.controller;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionAddable;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.api.controller.CyclingListControllerBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.HoverEvent;
import org.apache.commons.lang3.ObjectUtils;
import settingdust.mod_sets.ModSets;
import settingdust.mod_sets.data.ModSetsDisabledMods;
import settingdust.mod_sets.game.ModSetsIngameConfig;
import settingdust.mod_sets.game.data.ControllerRegistrar;
import settingdust.mod_sets.game.data.ModSet;
import settingdust.mod_sets.game.data.Rule;
import settingdust.mod_sets.game.util.ExtraCollectors;

public class CyclingControllerRegistrar
implements ControllerRegistrar {
    private final List<String> ids;
    private final String firstMod;

    public CyclingControllerRegistrar(List<String> ids) {
        this.ids = ids;
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("CyclingControllerRegistrar must have at least one mod");
        }
        this.firstMod = ids.get(0);
    }

    @Override
    public void registerRule(OptionAddable owner, Rule rule) {
        Option.Builder builder = Option.createBuilder().name(rule.text()).controller(opt -> CyclingListControllerBuilder.create((Option)opt).values(this.ids).formatValue(id -> {
            ModSet modSet = ModSetsIngameConfig.getModSetOrThrow(id);
            return modSet.text().copy().withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)modSet.description())));
        })).stateManager(StateManager.createInstant((Binding)Binding.generic((Object)this.firstMod, () -> {
            Map<String, ModSet> modSets = ModSetsIngameConfig.modSets();
            List<String> enabledModSets = this.ids.stream().filter(id -> {
                ModSet modSet = (ModSet)modSets.get(id);
                if (modSet == null) {
                    return false;
                }
                Set<String> mods = modSet.mods();
                return mods.stream().noneMatch(mod -> ModSetsDisabledMods.disabledMods().contains(mod));
            }).toList();
            if (enabledModSets.size() > 1) {
                ModSets.LOGGER.warn("More than one mod set is enabled in cycling list: {}. Will take the first and disable the others", (Object)String.join((CharSequence)", ", enabledModSets));
                ModSetsDisabledMods.disabledMods().addAll(enabledModSets.subList(1, enabledModSets.size()).stream().flatMap(it -> ModSetsIngameConfig.getModSetOrThrow(it).mods().stream()).toList());
                ModSetsDisabledMods.disabledMods().removeAll(ModSetsIngameConfig.getModSetOrThrow(enabledModSets.get(0)).mods());
            } else if (enabledModSets.isEmpty()) {
                ModSets.LOGGER.warn("No mod set is enabled in cycling list: {}. Will take the first", (Object)String.join((CharSequence)", ", this.ids));
            }
            String firstNonEmptyModSet = this.ids.stream().filter(it -> !ModSetsIngameConfig.getModSetOrThrow(it).mods().isEmpty()).findFirst().orElse(null);
            String enabledModSet = (String)enabledModSets.stream().filter(id -> !ModSetsIngameConfig.getModSetOrThrow(id).isDisabled()).collect(ExtraCollectors.singleOrNull());
            String selected = (String)ObjectUtils.firstNonNull((Object[])new String[]{enabledModSet, firstNonEmptyModSet, this.firstMod});
            ModSetsIngameConfig.getModSetOrThrow(selected).enableMods();
            return selected;
        }, id -> {})));
        owner.option(ControllerRegistrar.assignDescription(builder, rule, this.firstMod).build());
    }
}

