/*
 * Decompiled with CFR 0.152.
 */
package org.betterchristmaschests.mixin;

import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.state.ChestRenderState;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.state.properties.ChestType;
import org.betterchristmaschests.BetterChristmasChests;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sheets.class})
public class SheetsMixin {
    @Inject(at={@At(value="RETURN")}, method={"chooseMaterial(Lnet/minecraft/client/renderer/blockentity/state/ChestRenderState$ChestMaterialType;Lnet/minecraft/world/level/block/state/properties/ChestType;)Lnet/minecraft/client/resources/model/Material;"}, cancellable=true)
    private static void chooseMaterial(ChestRenderState.ChestMaterialType variant, ChestType type, CallbackInfoReturnable<Material> callbackInfoReturnable) {
        if (ChestRenderer.xmasTextures()) {
            switch (variant) {
                case ENDER_CHEST: {
                    callbackInfoReturnable.setReturnValue((Object)SheetsMixin.getChestId("ender", type));
                    break;
                }
                case COPPER_UNAFFECTED: {
                    callbackInfoReturnable.setReturnValue((Object)SheetsMixin.getChestId("copper", type));
                    break;
                }
                case COPPER_WEATHERED: {
                    callbackInfoReturnable.setReturnValue((Object)SheetsMixin.getChestId("copper_weathered", type));
                    break;
                }
                case COPPER_EXPOSED: {
                    callbackInfoReturnable.setReturnValue((Object)SheetsMixin.getChestId("copper_exposed", type));
                    break;
                }
                case COPPER_OXIDIZED: {
                    callbackInfoReturnable.setReturnValue((Object)SheetsMixin.getChestId("copper_oxidized", type));
                    break;
                }
                default: {
                    callbackInfoReturnable.setReturnValue((Object)((Material)callbackInfoReturnable.getReturnValue()));
                }
            }
        }
    }

    @Unique
    private static Material getChestId(String name, ChestType type) {
        String suffix = switch (type) {
            default -> throw new MatchException(null, null);
            case ChestType.SINGLE -> "";
            case ChestType.LEFT -> "_left";
            case ChestType.RIGHT -> "_right";
        };
        return new Material(Sheets.CHEST_SHEET, BetterChristmasChests.resourceLocation("entity/chest/" + name + suffix));
    }
}

