/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.igrium.craftui.impl.commands.CraftUICommand;
import com.igrium.craftui.impl.config.CraftUIConfig;
import com.igrium.craftui.impl.style.ImFontManager;
import com.igrium.craftui.impl.style.LayoutManager;
import com.igrium.craftui.impl.style.StyleManager;
import com.igrium.craftui.util.RaycastUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_3264;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftUI
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CraftUI");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("craftui.json");
    @NotNull
    private static final CraftUIConfig config = new CraftUIConfig();
    private static final Object configMutex = new Object();

    public void onInitializeClient() {
        CraftUI.initConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ImFontManager.getInstance());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)LayoutManager.getInstance());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)StyleManager.getInstance());
        RaycastUtils.register();
        if (CraftUI.getConfig().isEnableDebugCommands()) {
            ClientCommandRegistrationCallback.EVENT.register(CraftUICommand::register);
        }
    }

    public static boolean reloadConfig() {
        boolean bl;
        block8: {
            LOGGER.info("Loading CraftUI config from {}", (Object)CONFIG_FILE);
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);
            try {
                config.loadConfig(reader);
                config.applyConfig();
                bl = true;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Error loading CraftUI config", (Throwable)e);
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    public static CompletableFuture<Void> saveConfig() {
        config.applyConfig();
        return CompletableFuture.runAsync(() -> {
            Object object = configMutex;
            synchronized (object) {
                LOGGER.debug("Saving CraftUI config to {}", (Object)CONFIG_FILE);
                try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
                    config.saveConfig(writer);
                }
                catch (IOException e) {
                    LOGGER.error("Error saving CraftUI config", (Throwable)e);
                    throw ExceptionUtils.asRuntimeException((Throwable)e);
                }
            }
        }, (Executor)class_156.method_27958());
    }

    private static void initConfig() {
        if (Files.isRegularFile(CONFIG_FILE, new LinkOption[0])) {
            CraftUI.reloadConfig();
        } else {
            LOGGER.info("No CraftUI config found. Initializing...");
            CraftUI.saveConfig();
        }
    }

    @NotNull
    @Generated
    public static CraftUIConfig getConfig() {
        return config;
    }
}

