/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.app;

import com.igrium.craftui.CraftUI;
import com.igrium.craftui.CraftUIFonts;
import com.igrium.craftui.app.CraftApp;
import com.igrium.craftui.impl.input.CursorLockManager;
import com.igrium.craftui.impl.input.MouseUtils;
import com.igrium.craftui.impl.render.ImGuiUtil;
import com.igrium.craftui.impl.style.LayoutManager;
import com.igrium.craftui.impl.style.StyleManager;
import com.igrium.craftui.style.CraftUILayouts;
import com.igrium.craftui.style.CraftUIStyle;
import com.mojang.blaze3d.systems.RenderSystem;
import imgui.ImFont;
import imgui.ImGui;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1041;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CraftUI AppManager");
    private static final Set<CraftApp> apps = new HashSet<CraftApp>();
    private static final Queue<CraftApp> addQueue = new ArrayDeque<CraftApp>();
    private static final Queue<CraftApp> removeQueue = new ArrayDeque<CraftApp>();
    @Nullable
    private static CraftApp.ViewportBounds currentViewportBounds;
    private static boolean crashed;
    private static boolean forwardInputNextFrame;
    private static boolean forwardMouseInputNextFrame;
    private static boolean forceMouseUnlock;
    private static boolean needsCleanupFrame;

    public static Collection<CraftApp> getApps() {
        return Collections.unmodifiableSet(apps);
    }

    public static void openApp(CraftApp app) {
        RenderSystem.assertOnRenderThread();
        if (app == null) {
            throw new NullPointerException("app may not be null.");
        }
        removeQueue.remove(app);
        if (app.isOpen() || addQueue.contains(app)) {
            LOGGER.warn("CraftApp ({}) is already open!", (Object)app);
            return;
        }
        addQueue.add(app);
    }

    public static void closeApp(CraftApp app) {
        RenderSystem.assertOnRenderThread();
        if (app == null) {
            return;
        }
        addQueue.remove(app);
        if (!app.isOpen() || removeQueue.contains(app)) {
            LOGGER.warn("CraftApp ({}) is not open!", (Object)app);
            return;
        }
        removeQueue.add(app);
    }

    public static void preRender(class_310 client) {
        CraftApp app;
        RenderSystem.assertOnRenderThread();
        if (!ImGuiUtil.isInitialized()) {
            ImGuiUtil.init();
        }
        while (!removeQueue.isEmpty()) {
            app = removeQueue.poll();
            app.onClose();
            apps.remove(app);
        }
        while (!addQueue.isEmpty()) {
            app = addQueue.poll();
            apps.add(app);
            app.onOpen();
        }
        CursorLockManager.setForceUnlock(forceMouseUnlock);
        CursorLockManager.onBeginFrame();
        CraftApp.ViewportBounds prevViewportBounds = currentViewportBounds;
        currentViewportBounds = null;
        for (CraftApp app2 : apps) {
            CraftApp.ViewportBounds customBounds = app2.getCustomViewportBounds();
            if (customBounds == null) continue;
            currentViewportBounds = customBounds;
        }
        if (!Objects.equals(prevViewportBounds, currentViewportBounds)) {
            AppManager.updateViewportBounds(client);
        }
        if (apps.isEmpty()) {
            return;
        }
        for (CraftApp app2 : apps) {
            app2.preRender(client);
        }
    }

    private static void updateViewportBounds(class_310 client) {
        class_1041 window = client.method_22683();
        if (currentViewportBounds != null) {
            window.method_35642(currentViewportBounds.width());
            window.method_35643(currentViewportBounds.height());
        } else {
            window.method_35642(window.method_4480());
            window.method_35643(window.method_4507());
        }
        client.method_15993();
        client.field_1729.method_1599();
    }

    @Nullable
    public static CraftApp.ViewportBounds getCustomViewportBounds() {
        return currentViewportBounds;
    }

    public static Vector2d getViewportMousePos(double globalX, double globalY) {
        CraftApp.ViewportBounds viewportBounds = AppManager.getCustomViewportBounds();
        if (viewportBounds == null) {
            return new Vector2d(globalX, globalY);
        }
        return MouseUtils.calculateViewportMouse(class_310.method_1551().method_22683(), viewportBounds, globalX, globalY);
    }

    public static void forwardInputNextFrame() {
        forwardInputNextFrame = true;
    }

    public static void forwardMouseInputNextFrame() {
        forwardMouseInputNextFrame = true;
    }

    public static void forceMouseUnlock() {
        forceMouseUnlock = true;
    }

    public static void render(class_310 client) {
        LayoutManager layoutManager;
        RenderSystem.assertOnRenderThread();
        if (crashed) {
            return;
        }
        boolean isCleanupFrame = apps.isEmpty();
        if (client.field_1729.method_1613()) {
            ImGui.getIO().addConfigFlags(16);
        } else {
            ImGui.getIO().removeConfigFlags(16);
        }
        forwardInputNextFrame = false;
        forwardMouseInputNextFrame = false;
        forceMouseUnlock = false;
        if (isCleanupFrame && !needsCleanupFrame) {
            return;
        }
        StyleManager styleManager = StyleManager.getInstance();
        if (styleManager.isWantStyleUpdate()) {
            CraftUIStyle activeStyle = styleManager.getActiveStyleData();
            activeStyle.buildStyle(ImGui.getStyle());
            class_2960 font = activeStyle.getDefaultFont();
            if (font != null) {
                ImFont imFont = CraftUIFonts.getFont(font);
                ImGui.getIO().setFontDefault(imFont);
            }
            styleManager.setWantStyleUpdate(false);
        }
        class_2960 desiredLayout = null;
        for (CraftApp craftApp : apps) {
            class_2960 l = craftApp.getLayoutPreset();
            if (l == null) continue;
            desiredLayout = l;
        }
        if (desiredLayout != null) {
            CraftUILayouts.setActiveLayout(desiredLayout);
        }
        if ((layoutManager = LayoutManager.getInstance()).isLayoutUpdate()) {
            ImGui.loadIniSettingsFromMemory((String)layoutManager.getActiveLayoutData());
            layoutManager.setLayoutUpdate(false);
        }
        ImGuiUtil.IM_GLFW.newFrame();
        ImGui.newFrame();
        for (CraftApp app : apps) {
            ImGui.pushID((int)app.getClass().getCanonicalName().hashCode());
            try {
                app.render(client);
            }
            catch (Exception e) {
                crashed = true;
                class_128 crashReport = new class_128("Error rendering CraftUI app " + app.getClass().getSimpleName(), (Throwable)e);
                throw new class_148(crashReport);
            }
            ImGui.popID();
        }
        if (isCleanupFrame) {
            ImGui.setWindowFocus(null);
            ImGui.getIO().setWantCaptureKeyboard(false);
            ImGui.getIO().setWantCaptureMouse(false);
        }
        ImGui.render();
        ImGuiUtil.IM_GL3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long l = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)l);
        }
        if (ImGui.getIO().getWantSaveIniSettings() && CraftUI.getConfig().isLayoutPersistent()) {
            LayoutManager.getInstance().saveUserLayoutData(ImGui.saveIniSettingsToMemory());
            ImGui.getIO().setWantSaveIniSettings(false);
        }
        needsCleanupFrame = !isCleanupFrame;
    }

    public static boolean wantCaptureMouse() {
        return !forwardMouseInputNextFrame && ImGui.getIO().getWantCaptureKeyboard();
    }

    public static boolean wantCaptureKeyboard() {
        return !forwardInputNextFrame && ImGui.getIO().getWantCaptureKeyboard();
    }
}

