/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.app;

import com.igrium.craftui.app.AppManager;
import com.igrium.craftui.app.CraftApp;
import com.igrium.craftui.impl.input.CursorLockManager;
import imgui.ImGui;
import imgui.ImGuiViewport;
import lombok.Generated;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public abstract class DockSpaceApp
extends CraftApp {
    private int dockSpaceId;
    private CraftApp.ViewportBounds viewportBounds = new CraftApp.ViewportBounds(0, 0, 1, 1);
    private boolean didBeginViewport;
    private ViewportInputMode viewportInputMode = ViewportInputMode.FOCUS;
    private int @Nullable [] viewportInputButtons = new int[]{1};

    public void setViewportInputButtons(int ... buttons) {
        this.viewportInputButtons = buttons;
    }

    @Override
    protected void render(class_310 client) {
        ImGui.setNextWindowBgAlpha((float)0.0f);
        this.dockSpaceId = ImGui.dockSpaceOverViewport((ImGuiViewport)ImGui.getMainViewport());
        this.didBeginViewport = false;
    }

    protected static boolean mousePressedOverViewport(int mouseButton) {
        return (ImGui.isWindowHovered() || class_310.method_1551().field_1729.method_1613()) && ImGui.isMouseDown((int)mouseButton);
    }

    private static void unlockIfWindowFocused() {
        if (ImGui.isWindowFocused((int)4)) {
            AppManager.forceMouseUnlock();
        }
    }

    private boolean isViewportButtonDown() {
        if (this.viewportInputButtons == null) {
            return false;
        }
        for (int button : this.viewportInputButtons) {
            if (!DockSpaceApp.mousePressedOverViewport(button)) continue;
            return true;
        }
        return false;
    }

    protected final boolean beginViewport(String name, int imGuiWindowFlags) {
        float yPos;
        float xPos;
        if (this.didBeginViewport) {
            throw new IllegalStateException("beginViewport only may be called once per frame! Also, make sure you're calling super.render() at the beginning of render.");
        }
        this.didBeginViewport = true;
        ImGui.setNextWindowDockID((int)this.dockSpaceId);
        if (!ImGui.begin((String)name, (int)(imGuiWindowFlags | 0x80))) {
            AppManager.forceMouseUnlock();
            return false;
        }
        if (this.viewportInputMode == ViewportInputMode.FOCUS || !CursorLockManager.clientWantsLockCursor()) {
            if (ImGui.isWindowFocused()) {
                ImGui.setWindowFocus(null);
            }
            DockSpaceApp.unlockIfWindowFocused();
        } else {
            switch (this.viewportInputMode.ordinal()) {
                case 0: {
                    if (!ImGui.isWindowFocused((int)4)) {
                        ImGui.setWindowFocus();
                    }
                    AppManager.forceMouseUnlock();
                    break;
                }
                case 1: {
                    if (this.isViewportButtonDown()) {
                        ImGui.setWindowFocus(null);
                    } else if (!ImGui.isWindowFocused((int)4)) {
                        ImGui.setWindowFocus();
                    }
                    DockSpaceApp.unlockIfWindowFocused();
                    break;
                }
                case 3: {
                    ImGui.setWindowFocus(null);
                    class_310.method_1551().field_1729.method_1612();
                }
            }
        }
        if (ImGui.isWindowHovered() && class_310.method_1551().field_1755 != null) {
            AppManager.forwardMouseInputNextFrame();
        }
        float minX = ImGui.getWindowContentRegionMinX();
        float maxX = ImGui.getWindowContentRegionMaxX();
        float minY = ImGui.getWindowContentRegionMinY();
        float maxY = ImGui.getWindowContentRegionMaxY();
        if (ImGui.getIO().hasConfigFlags(1024)) {
            xPos = ImGui.getWindowPosX() - ImGui.getWindowViewport().getPosX() + minX;
            yPos = ImGui.getWindowPosY() - ImGui.getWindowViewport().getPosY() + minY;
        } else {
            xPos = ImGui.getWindowPosX() + minX;
            yPos = ImGui.getWindowPosY() + minY;
        }
        yPos = ImGui.getWindowViewport().getSizeY() - yPos - (maxY - minY);
        float width = Math.max(maxX - minX, 1.0f);
        float height = Math.max(maxY - minY, 1.0f);
        this.viewportBounds = new CraftApp.ViewportBounds((int)xPos, (int)yPos, (int)width, (int)height);
        return true;
    }

    @Override
    protected CraftApp.ViewportBounds getCustomViewportBounds() {
        return this.viewportBounds;
    }

    @Generated
    public int getDockSpaceId() {
        return this.dockSpaceId;
    }

    @Generated
    public ViewportInputMode getViewportInputMode() {
        return this.viewportInputMode;
    }

    @Generated
    public void setViewportInputMode(ViewportInputMode viewportInputMode) {
        this.viewportInputMode = viewportInputMode;
    }

    @Generated
    public int @Nullable [] getViewportInputButtons() {
        return this.viewportInputButtons;
    }

    public static enum ViewportInputMode {
        NONE,
        HOLD,
        FOCUS,
        ALWAYS;

    }
}

