/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.event;

import com.igrium.craftui.event.CollectionBackedUIEvent;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

public interface UIEvent<T> {
    public T invoker();

    public void addListener(T var1);

    public void removeListener(Object var1);

    public static <T> UIEvent<T> collectionBacked(Function<Collection<? extends T>, T> invokerFactory) {
        return new CollectionBackedUIEvent<T>(invokerFactory);
    }

    public static <T> UIEvent<Consumer<T>> ofConsumer() {
        return new CollectionBackedUIEvent<Consumer<T>>(listeners -> val -> {
            for (Consumer l : listeners) {
                l.accept(val);
            }
        });
    }

    public static UIEvent<Runnable> ofRunnable() {
        return new CollectionBackedUIEvent<Runnable>(listeners -> () -> {
            for (Runnable l : listeners) {
                l.run();
            }
        });
    }
}

