/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.file;

import com.igrium.craftui.CraftUI;
import com.igrium.craftui.file.FileDialogInterface;
import com.igrium.craftui.file.ImFileDialog;
import com.igrium.craftui.file.NFDFileDialog;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDialogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDialogs.class);
    private static NFDFileDialog nfdImpl;
    private static ImFileDialog imImpl;
    private static FileDialogInterface impl;

    private static boolean isPreferNative() {
        return CraftUI.getConfig().isPreferNativeFileDialog();
    }

    private static synchronized void init() {
        if (!(impl != null || FileDialogs.isPreferNative() && FileDialogs.initNfd())) {
            FileDialogs.initImgui();
        }
    }

    private static boolean initNfd() {
        if (nfdImpl == null) {
            try {
                NFDFileDialog newImpl = new NFDFileDialog();
                newImpl.init();
                nfdImpl = newImpl;
            }
            catch (Throwable e) {
                LOGGER.error("Error initializing NFD. Falling back to internal.", e);
                return false;
            }
        }
        impl = nfdImpl;
        return true;
    }

    private static void initImgui() {
        if (imImpl == null) {
            imImpl = new ImFileDialog();
            imImpl.init();
        }
        impl = imImpl;
    }

    public static void clearImpl() {
        impl = null;
    }

    public static CompletableFuture<Optional<String>> showSaveDialog(@Nullable String defaultPath, @Nullable String defaultName, FileFilter ... filters) {
        FileDialogs.init();
        return impl.showSaveDialog(defaultPath, defaultName, filters).exceptionally(FileDialogs::handle);
    }

    public static CompletableFuture<Optional<String>> showOpenDialog(@Nullable String defaultPath, FileFilter ... filters) {
        FileDialogs.init();
        return impl.showOpenDialog(defaultPath, filters).exceptionally(FileDialogs::handle);
    }

    public static CompletableFuture<Optional<String>> showOpenFolderDialog(@Nullable String defaultPath) {
        FileDialogs.init();
        return impl.showOpenFolderDialog(defaultPath).exceptionally(FileDialogs::handle);
    }

    private static Optional<String> handle(Throwable e) {
        LOGGER.error("Error opening file dialog", e);
        return Optional.empty();
    }

    public record FileFilter(String name, String[] extensions) {
    }
}

