/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.file;

import com.igrium.craftui.app.AppManager;
import com.igrium.craftui.file.FileDialogInterface;
import com.igrium.craftui.file.FileDialogs;
import com.igrium.craftui.file.ImFileDialogApp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

class ImFileDialog
implements FileDialogInterface {
    ImFileDialog() {
    }

    @Override
    public void init() {
    }

    @Override
    public CompletableFuture<Optional<String>> showSaveDialog(@Nullable String defaultPath, @Nullable String defaultName, FileDialogs.FileFilter ... filters) {
        String ext;
        ImFileDialogApp app = new ImFileDialogApp();
        if (defaultPath != null) {
            app.setDefaultPath(defaultPath);
        }
        if (defaultName != null) {
            app.setDefaultFilename(defaultName);
        }
        if (filters != null && filters.length != 0) {
            app.setFilters(ImFileDialog.compileFilters(filters));
        } else if (defaultName != null && !(ext = FilenameUtils.getExtension((String)defaultName)).isBlank()) {
            app.setFilters("." + ext);
        }
        app.setTitle("Save As");
        app.setWarnOnOverride(true);
        CompletableFuture<Optional<String>> future = app.getFuture();
        AppManager.openApp(app);
        future.whenComplete((opt, t) -> AppManager.closeApp(app));
        return future;
    }

    @Override
    public CompletableFuture<Optional<String>> showOpenDialog(@Nullable String defaultPath, FileDialogs.FileFilter ... filters) {
        ImFileDialogApp app = new ImFileDialogApp();
        if (defaultPath != null) {
            app.setDefaultPath(defaultPath);
        }
        if (filters != null && filters.length != 0) {
            app.setFilters(ImFileDialog.compileFilters(filters));
        }
        CompletableFuture<Optional<String>> future = app.getFuture();
        AppManager.openApp(app);
        future.whenComplete((opt, t) -> AppManager.closeApp(app));
        return future;
    }

    @Override
    public CompletableFuture<Optional<String>> showOpenFolderDialog(@Nullable String defaultPath) {
        ImFileDialogApp app = new ImFileDialogApp();
        if (defaultPath != null) {
            app.setDefaultPath(defaultPath);
        }
        app.setFilters(null);
        app.setTitle("Select Folder");
        CompletableFuture<Optional<String>> future = app.getFuture();
        AppManager.openApp(app);
        future.whenComplete((opt, t) -> AppManager.closeApp(app));
        return future;
    }

    private static String compileFilters(FileDialogs.FileFilter ... filters) {
        List<String> strings = Arrays.stream(filters).flatMap(f -> Arrays.stream(f.extensions())).map(f -> f.startsWith(".") ? f : "." + f).toList();
        return String.join((CharSequence)",", strings);
    }
}

