/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.file;

import com.igrium.craftui.file.FileDialogInterface;
import com.igrium.craftui.file.FileDialogs;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.nfd.NFDFilterItem;
import org.lwjgl.util.nfd.NativeFileDialog;

class NFDFileDialog
implements FileDialogInterface {
    private static final ThreadLocal<Boolean> initialized = ThreadLocal.withInitial(() -> false);
    private static final Executor dialogExecutor = class_310.field_1703 ? class_310.method_1551() : Executors.newSingleThreadExecutor(r -> new Thread(r, "File Dialog Thread"));

    NFDFileDialog() {
    }

    private static int tryInit() {
        if (!initialized.get().booleanValue()) {
            int result = NativeFileDialog.NFD_Init();
            if (result != 1) {
                throw new RuntimeException("Unknown native error initializing NativeFileDialog.");
            }
            initialized.set(true);
            return result;
        }
        return 1;
    }

    @Override
    public void init() throws Exception {
        NFDFileDialog.tryInit();
    }

    @Override
    public CompletableFuture<Optional<String>> showSaveDialog(@Nullable String defaultPath, @Nullable String defaultName, FileDialogs.FileFilter ... filters) {
        return CompletableFuture.supplyAsync(() -> this.saveDialogSync(defaultPath, defaultName, filters), dialogExecutor);
    }

    public Optional<String> saveDialogSync(@Nullable String defaultPath, @Nullable String defaultName, FileDialogs.FileFilter ... filters) {
        NFDFileDialog.tryInit();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer out = stack.callocPointer(1);
            NFDFilterItem.Buffer filter = NFDFileDialog.createFilters(filters, stack);
            int result = NativeFileDialog.NFD_SaveDialog((PointerBuffer)out, (NFDFilterItem.Buffer)filter, (CharSequence)defaultPath, (CharSequence)defaultName);
            if (result == 1) {
                String returnVal = out.getStringUTF8(0);
                NativeFileDialog.NFD_FreePath((long)out.get(0));
                Optional<String> optional = Optional.of(returnVal);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
    }

    @Override
    public CompletableFuture<Optional<String>> showOpenDialog(@Nullable String defaultPath, FileDialogs.FileFilter ... filters) {
        return CompletableFuture.supplyAsync(() -> this.openDialogSync(defaultPath, filters), dialogExecutor);
    }

    public Optional<String> openDialogSync(@Nullable String defaultPath, FileDialogs.FileFilter ... filters) {
        NFDFileDialog.tryInit();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer out = stack.callocPointer(1);
            NFDFilterItem.Buffer filter = NFDFileDialog.createFilters(filters, stack);
            int result = NativeFileDialog.NFD_OpenDialog((PointerBuffer)out, (NFDFilterItem.Buffer)filter, (CharSequence)defaultPath);
            if (result == 1) {
                String returnVal = out.getStringUTF8(0);
                NativeFileDialog.NFD_FreePath((long)out.get(0));
                Optional<String> optional = Optional.of(returnVal);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
    }

    @Override
    public CompletableFuture<Optional<String>> showOpenFolderDialog(@Nullable String defaultPath) {
        return CompletableFuture.supplyAsync(() -> this.pickFolderSync(defaultPath), dialogExecutor);
    }

    public Optional<String> pickFolderSync(@Nullable String defaultPath) {
        NFDFileDialog.tryInit();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer out = stack.callocPointer(1);
            int result = NativeFileDialog.NFD_PickFolder((PointerBuffer)out, (CharSequence)defaultPath);
            if (result == 1) {
                String returnVal = out.getStringUTF8(0);
                NativeFileDialog.NFD_FreePath((long)out.get(0));
                Optional<String> optional = Optional.of(returnVal);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
    }

    private static NFDFilterItem.Buffer createFilters(FileDialogs.FileFilter[] fileFilters, MemoryStack stack) {
        if (fileFilters == null || fileFilters.length == 0) {
            return null;
        }
        NFDFilterItem.Buffer buffer = NFDFilterItem.malloc((int)fileFilters.length, (MemoryStack)stack);
        for (int i = 0; i < fileFilters.length; ++i) {
            NFDFilterItem item = (NFDFilterItem)buffer.get(i);
            FileDialogs.FileFilter filter = fileFilters[i];
            List<String> extensions = Arrays.stream(filter.extensions()).map(ext -> {
                if ((ext = ext.trim()).startsWith("*.")) {
                    return ext.substring(2);
                }
                if (ext.startsWith("*") || ext.startsWith(".")) {
                    return ext.substring(1);
                }
                return ext;
            }).filter(ext -> !ext.isBlank()).toList();
            String spec = String.join((CharSequence)",", extensions);
            item.name(stack.UTF8((CharSequence)fileFilters[i].name()));
            item.spec(stack.UTF8((CharSequence)spec));
        }
        return buffer;
    }
}

