/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.impl.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.JsonAdapter;
import com.igrium.craftui.file.FileDialogs;
import com.igrium.craftui.impl.util.IdentifierJsonAdapter;
import com.igrium.craftui.style.CraftUIStyles;
import java.io.Reader;
import java.io.Writer;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public final class CraftUIConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @JsonAdapter(value=IdentifierJsonAdapter.class)
    private class_2960 style = CraftUIStyles.DARK;
    private boolean preferNativeFileDialog = true;
    private boolean enableViewports = false;
    private boolean layoutPersistent = true;
    private boolean enableDebugCommands = FabricLoader.getInstance().isDevelopmentEnvironment();

    public void copyFrom(CraftUIConfig other) {
        this.preferNativeFileDialog = other.preferNativeFileDialog;
        this.enableViewports = other.enableViewports;
        this.enableDebugCommands = other.enableDebugCommands;
    }

    public void loadConfig(Reader reader) {
        CraftUIConfig otherConfig = (CraftUIConfig)GSON.fromJson(reader, CraftUIConfig.class);
        this.copyFrom(otherConfig);
    }

    public void saveConfig(Writer writer) {
        GSON.toJson((Object)this, (Appendable)writer);
    }

    public void applyConfig() {
        FileDialogs.clearImpl();
        CraftUIStyles.setActiveStyle(this.style);
    }

    @Generated
    public void setStyle(class_2960 style) {
        this.style = style;
    }

    @Generated
    public void setPreferNativeFileDialog(boolean preferNativeFileDialog) {
        this.preferNativeFileDialog = preferNativeFileDialog;
    }

    @Generated
    public void setEnableViewports(boolean enableViewports) {
        this.enableViewports = enableViewports;
    }

    @Generated
    public void setLayoutPersistent(boolean layoutPersistent) {
        this.layoutPersistent = layoutPersistent;
    }

    @Generated
    public void setEnableDebugCommands(boolean enableDebugCommands) {
        this.enableDebugCommands = enableDebugCommands;
    }

    @Generated
    public class_2960 getStyle() {
        return this.style;
    }

    @Generated
    public boolean isPreferNativeFileDialog() {
        return this.preferNativeFileDialog;
    }

    @Generated
    public boolean isEnableViewports() {
        return this.enableViewports;
    }

    @Generated
    public boolean isLayoutPersistent() {
        return this.layoutPersistent;
    }

    @Generated
    public boolean isEnableDebugCommands() {
        return this.enableDebugCommands;
    }
}

