/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.impl.config;

import com.igrium.craftui.CraftUI;
import com.igrium.craftui.app.CraftApp;
import com.igrium.craftui.file.FileDialogs;
import com.igrium.craftui.impl.config.CraftUIConfig;
import com.igrium.craftui.screen.CraftAppScreen;
import com.igrium.craftui.style.CraftUILayouts;
import com.igrium.craftui.style.CraftUIStyles;
import imgui.ImGui;
import imgui.ImGuiViewport;
import imgui.type.ImBoolean;
import imgui.type.ImInt;
import java.util.Arrays;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftUIConfigApp
extends CraftApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(CraftUIConfigApp.class);
    private final CraftUIConfig config = CraftUI.getConfig();
    private final ImBoolean preferNativeFileDialog = new ImBoolean(this.config.isPreferNativeFileDialog());
    private final ImBoolean enableViewports = new ImBoolean(this.config.isEnableViewports());
    private final ImBoolean layoutPersistent = new ImBoolean(this.config.isLayoutPersistent());
    private final ImBoolean enableDebugCommand = new ImBoolean(this.config.isEnableDebugCommands());
    private final class_2960[] styles;
    private final String[] styleNames;
    private final ImInt selectedStyle = new ImInt();

    public CraftUIConfigApp() {
        this.styles = CraftUIStyles.getStyles().keySet().toArray(new class_2960[0]);
        this.styleNames = (String[])Arrays.stream(this.styles).map(i -> class_2477.method_10517().method_48307(i.method_42093("style"))).toArray(String[]::new);
        int styleIndex = CraftUIConfigApp.find(CraftUIStyles.getActiveStyle(), this.styles);
        if (styleIndex >= 0) {
            this.selectedStyle.set(styleIndex);
        }
    }

    private static <T> int find(T value, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void render(class_310 client) {
        boolean wantsSave = false;
        ImGuiViewport viewport = ImGui.getMainViewport();
        ImGui.setNextWindowPos((float)viewport.getCenterX(), (float)viewport.getCenterY(), (int)1, (float)0.5f, (float)0.5f);
        if (ImGui.begin((String)class_2561.method_43471((String)"options.craftui.header").getString(), (int)294)) {
            if (ImGui.getIO().getKeysDown(256) && ImGui.isWindowFocused()) {
                this.close();
            }
            if (this.combo("options.craftui.style", this.selectedStyle, this.styleNames, "options.craftui.style.tooltip")) {
                wantsSave = true;
            }
            if (this.checkbox("options.craftui.preferNativeFileDialog", this.preferNativeFileDialog, "options.craftui.preferNativeFileDialog.tooltip")) {
                wantsSave = true;
            }
            if (this.checkbox("options.craftui.enableViewports", this.enableViewports, "options.craftui.enableViewports.tooltip")) {
                wantsSave = true;
            }
            if (this.checkbox("options.craftui.layoutPersistent", this.layoutPersistent, "options.craftui.layoutPersistent.tooltip")) {
                wantsSave = true;
            }
            if (this.checkbox("options.craftui.enableDebugCommands", this.enableDebugCommand, "options.craftui.enableDebugCommands.tooltip")) {
                wantsSave = true;
            }
            ImGui.separator();
            if (this.button("options.craftui.resetLayout", "options.craftui.resetLayout.tooltip")) {
                CraftUILayouts.resetLayouts();
            }
            ImGui.sameLine();
            if (this.button("options.craftui.testFileDialog", "options.craftui.testFileDialog.tooltip")) {
                FileDialogs.showOpenDialog(null, new FileDialogs.FileFilter[0]).whenComplete((v, e) -> {
                    if (e != null) {
                        LOGGER.error("Error opening file dialog: ", e);
                    } else {
                        v.ifPresentOrElse(file -> LOGGER.info("You opened {}", file), () -> LOGGER.info("You didn't choose a file."));
                    }
                });
            }
            ImGui.separator();
            if (this.button("gui.done", null)) {
                this.close();
            }
        }
        ImGui.end();
        if (wantsSave) {
            this.save();
        }
    }

    private boolean checkbox(String name, ImBoolean active, @Nullable String tooltip) {
        boolean updated = ImGui.checkbox((String)class_2477.method_10517().method_48307(name), (ImBoolean)active);
        this.setTooltip(tooltip);
        return updated;
    }

    private boolean combo(String name, ImInt currentItem, String[] items, @Nullable String tooltip) {
        boolean updated = ImGui.combo((String)class_2477.method_10517().method_48307(name), (ImInt)currentItem, (String[])items);
        this.setTooltip(tooltip);
        return updated;
    }

    private boolean button(String name, @Nullable String tooltip) {
        boolean pressed = ImGui.button((String)class_2477.method_10517().method_48307(name));
        this.setTooltip(tooltip);
        return pressed;
    }

    private void setTooltip(@Nullable String tooltip) {
        if (tooltip != null && ImGui.isItemHovered((int)512)) {
            ImGui.setTooltip((String)class_2477.method_10517().method_48307(tooltip));
        }
    }

    private void save() {
        this.config.setStyle(this.styles[this.selectedStyle.get()]);
        this.config.setPreferNativeFileDialog(this.preferNativeFileDialog.get());
        this.config.setEnableViewports(this.enableViewports.get());
        this.config.setLayoutPersistent(this.layoutPersistent.get());
        this.config.setEnableDebugCommands(this.enableDebugCommand.get());
        CraftUI.saveConfig();
    }

    public static CraftAppScreen<CraftUIConfigApp> createScreen() {
        return new CraftAppScreen<CraftUIConfigApp>(new CraftUIConfigApp());
    }
}

