/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.impl.style;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.igrium.craftui.event.FontReloadCallback;
import com.igrium.craftui.impl.render.ImGuiUtil;
import com.igrium.craftui.impl.util.IdentifierJsonAdapter;
import com.igrium.craftui.impl.util.Vector2fJsonAdapter;
import com.mojang.blaze3d.systems.RenderSystem;
import imgui.ImFont;
import imgui.ImFontAtlas;
import imgui.ImFontConfig;
import imgui.ImGui;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_5611;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImFontManager
implements IdentifiableResourceReloadListener {
    private static ImFontManager instance;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new IdentifierJsonAdapter()).registerTypeAdapter(class_5611.class, (Object)new Vector2fJsonAdapter()).setPrettyPrinting().create();
    private final Map<class_2960, ImFont> fonts = new HashMap<class_2960, ImFont>();
    private ImFont defaultFont;
    private final Map<class_2960, LoadedFontFile> fontFiles = new HashMap<class_2960, LoadedFontFile>();
    private final Set<class_2960> complainedIds = new HashSet<class_2960>();

    public static ImFontManager getInstance() {
        if (instance == null) {
            instance = new ImFontManager();
        }
        return instance;
    }

    private ImFontManager() {
    }

    private static ImFontAtlas getFontAtlas() {
        return ImGui.getIO().getFonts();
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor) {
        this.fontFiles.clear();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Map.Entry entry : manager.method_14488("fonts", id -> id.method_12832().endsWith(".ttf")).entrySet()) {
            class_2960 fileName = (class_2960)entry.getKey();
            String fontPath = fileName.method_12832().substring("fonts/".length());
            fontPath = FilenameUtils.removeExtension((String)fontPath);
            class_2960 fontID = class_2960.method_60655((String)fileName.method_12836(), (String)fontPath);
            LoadedFontFile file = new LoadedFontFile();
            this.fontFiles.put(fontID, file);
            futures.add(CompletableFuture.runAsync(() -> {
                class_2960 configId = class_2960.method_60655((String)fontID.method_12836(), (String)("fonts/" + fontID.method_12832() + ".json"));
                Optional configFile = manager.method_14486(configId);
                FontConfig config = new FontConfig();
                if (configFile.isPresent()) {
                    try (BufferedReader reader = ((class_3298)configFile.get()).method_43039();){
                        config = (FontConfig)this.GSON.fromJson((Reader)reader, FontConfig.class);
                    }
                    catch (Exception e) {
                        this.LOGGER.error("Error loading font config file " + String.valueOf(configId), (Throwable)e);
                    }
                }
                file.config = config;
                this.LOGGER.info("Loading font {} as {}", (Object)fileName, (Object)fontID);
                try (BufferedInputStream in = new BufferedInputStream(((class_3298)entry.getValue()).method_14482());){
                    file.fileContents = in.readAllBytes();
                }
                catch (Exception e) {
                    this.LOGGER.error("Error loading font " + String.valueOf(fontID), (Throwable)e);
                }
            }, prepareExecutor));
        }
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenRunAsync(this::renderFonts, applyExecutor);
    }

    public void renderFonts() {
        this.renderFonts(this.fontFiles);
    }

    private void renderFonts(Map<class_2960, LoadedFontFile> files) {
        RenderSystem.assertOnRenderThreadOrInit();
        ImGuiUtil.ensureInitialized();
        this.fonts.clear();
        this.complainedIds.clear();
        ImFontAtlas atlas = ImFontManager.getFontAtlas();
        atlas.clear();
        this.defaultFont = atlas.addFontDefault();
        for (Map.Entry<class_2960, LoadedFontFile> entry : files.entrySet()) {
            LoadedFontFile file = entry.getValue();
            if (file.fileContents == null || file.fileContents.length == 0) {
                this.LOGGER.warn("Font {} did not have any file contents. Check above for errors.", (Object)entry.getKey());
                continue;
            }
            try {
                ImFont font = this.renderFont(atlas, file);
                this.fonts.put(entry.getKey(), font);
            }
            catch (Exception e) {
                this.LOGGER.error("Error rendering font {}. The ttf file was likely invalid.", (Object)entry.getKey(), (Object)e);
            }
        }
        atlas.build();
        ImGuiUtil.IM_GL3.updateFontsTexture();
        atlas.clearTexData();
        Iterator<Map.Entry<class_2960, ImFont>> fontIterator = this.fonts.entrySet().iterator();
        while (fontIterator.hasNext()) {
            Map.Entry<class_2960, LoadedFontFile> entry;
            entry = fontIterator.next();
            if (((ImFont)entry.getValue()).isLoaded()) continue;
            this.LOGGER.warn("Font {} was not loaded properly. Please ensure valid glyph ranges.", (Object)entry.getKey());
            fontIterator.remove();
        }
        this.LOGGER.info("Created font atlas with {} font(s)", (Object)this.fonts.size());
        ((FontReloadCallback)FontReloadCallback.EVENT.invoker()).onFontsReloaded(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImFont renderFont(ImFontAtlas atlas, LoadedFontFile file) {
        FontConfig config = file.config;
        ImFontConfig imConfig = new ImFontConfig();
        float size = config.size * 16.0f;
        try {
            imConfig.setSizePixels(size);
            if (config.oversampleH != null) {
                imConfig.setOversampleH(config.oversampleH.intValue());
            }
            if (config.oversampleV != null) {
                imConfig.setOversampleV(config.oversampleV.intValue());
            }
            if (config.pixelSnapH != null) {
                imConfig.setPixelSnapH(config.pixelSnapH.booleanValue());
            }
            if (config.glyphMinAdvanceX != null) {
                imConfig.setGlyphMinAdvanceX(config.glyphMinAdvanceX.floatValue());
            }
            if (config.glyphMaxAdvanceX != null) {
                imConfig.setGlyphMaxAdvanceX(config.glyphMaxAdvanceX.floatValue());
            }
            if (config.glyphExtraSpacing != null) {
                imConfig.setGlyphExtraSpacing(config.glyphExtraSpacing.method_32118(), config.glyphExtraSpacing.method_32119());
            }
            if (config.glyphOffset != null || config.scaledGlyphOffset != null) {
                float scale = 1.0f;
                float offsetX = 0.0f;
                float offsetY = 0.0f;
                if (config.glyphOffset != null) {
                    offsetX += config.glyphOffset.method_32118();
                    offsetY += config.glyphOffset.method_32119();
                }
                if (config.scaledGlyphOffset != null) {
                    offsetX += config.scaledGlyphOffset.method_32118() * scale;
                    offsetY += config.scaledGlyphOffset.method_32119() * scale;
                }
                imConfig.setGlyphOffset(offsetX, offsetY);
            }
            if (config.glyphRanges != null) {
                ImFont imFont = atlas.addFontFromMemoryTTF(file.fileContents, size, imConfig, config.glyphRanges);
                return imFont;
            }
            ImFont imFont = atlas.addFontFromMemoryTTF(file.fileContents, size, imConfig);
            return imFont;
        }
        finally {
            imConfig.destroy();
        }
    }

    public Map<class_2960, ImFont> getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public ImFont get(class_2960 id) {
        ImFont font = this.fonts.get(id);
        if (font == null) {
            if (!this.complainedIds.contains(id)) {
                this.LOGGER.warn("Unknown font: " + String.valueOf(id));
                this.complainedIds.add(id);
            }
            return this.defaultFont;
        }
        return font;
    }

    public class_2960 getFabricId() {
        return class_2960.method_60654((String)"craftui:fonts");
    }

    private static class LoadedFontFile {
        FontConfig config;
        byte[] fileContents;

        private LoadedFontFile() {
        }
    }

    private static class FontConfig {
        public float size = 1.0f;
        @Nullable
        public Integer oversampleH;
        @Nullable
        public Integer oversampleV;
        public Boolean pixelSnapH;
        @Nullable
        public Float glyphMinAdvanceX;
        @Nullable
        public Float glyphMaxAdvanceX;
        @Nullable
        public class_5611 glyphExtraSpacing;
        @Nullable
        public class_5611 glyphOffset;
        @Nullable
        public class_5611 scaledGlyphOffset;
        @JsonAdapter(value=GlyphRangeTypeAdapter.class)
        public short @Nullable [] glyphRanges;

        private FontConfig() {
        }
    }

    private static class GlyphRangeTypeAdapter
    extends TypeAdapter<short[]> {
        private GlyphRangeTypeAdapter() {
        }

        public void write(JsonWriter out, short[] value) throws IOException {
            out.beginArray();
            for (short s : value) {
                out.value(Integer.toHexString(s));
            }
            out.endArray();
        }

        public short[] read(JsonReader in) throws IOException {
            ShortArrayList list = new ShortArrayList();
            in.beginArray();
            while (in.peek() != JsonToken.END_ARRAY) {
                if (in.peek() == JsonToken.STRING) {
                    list.add(GlyphRangeTypeAdapter.parseShort(in.nextString()));
                    continue;
                }
                list.add((short)in.nextInt());
            }
            in.endArray();
            return list.toShortArray();
        }

        private static short parseShort(String hex) {
            if (hex.startsWith("0x")) {
                hex = hex.substring(2);
            } else if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            return (short)Integer.parseInt(hex, 16);
        }
    }
}

