/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.impl.style;

import com.igrium.craftui.CraftUI;
import com.igrium.craftui.style.CraftUILayouts;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutManager
implements IdentifiableResourceReloadListener {
    private static LayoutManager instance;
    private static final Logger LOGGER;
    private final Map<class_2960, String> nativeLayouts = new ConcurrentHashMap<class_2960, String>();
    private final Map<class_2960, String> userLayouts = new ConcurrentHashMap<class_2960, String>();
    @NotNull
    private class_2960 activeLayout = CraftUILayouts.DEFAULT;
    private boolean layoutUpdate = true;

    public static LayoutManager getInstance() {
        if (instance == null) {
            instance = new LayoutManager();
        }
        return instance;
    }

    private LayoutManager() {
    }

    public void setActiveLayout(@Nullable class_2960 layout) {
        if (layout == null) {
            layout = CraftUILayouts.DEFAULT;
        }
        if (this.activeLayout.equals((Object)layout)) {
            return;
        }
        this.activeLayout = layout;
        this.setLayoutUpdate(true);
    }

    @NotNull
    public String getActiveLayoutData() {
        String data = this.getLayoutData(this.getActiveLayout());
        return data != null ? data : "";
    }

    @Nullable
    public String getNativeLayoutData(class_2960 id) {
        return this.nativeLayouts.get(id);
    }

    @Nullable
    public String getUserLayoutData(class_2960 id) {
        return this.userLayouts.get(id);
    }

    @Nullable
    public String getLayoutData(class_2960 id) {
        String d = this.getUserLayoutData(id);
        return d != null ? d : this.getNativeLayoutData(id);
    }

    public void setUserLayoutData(class_2960 layoutId, String data, boolean save) {
        this.userLayouts.put(layoutId, data);
        if (save && CraftUI.getConfig().isLayoutPersistent()) {
            this.saveUserLayout(layoutId);
        }
    }

    public void saveUserLayoutData(String data) {
        this.setUserLayoutData(this.getActiveLayout(), data, true);
    }

    public void resetLayout(class_2960 id) {
        this.userLayouts.remove(id);
        try {
            Files.deleteIfExists(LayoutManager.getUserLayoutPath(id));
        }
        catch (IOException e) {
            LOGGER.error("Error removing user layout: ", (Throwable)e);
        }
        if (this.getActiveLayout().equals((Object)id)) {
            this.setLayoutUpdate(true);
        }
    }

    public void resetLayouts() {
        this.userLayouts.clear();
        Path layoutDir = FabricLoader.getInstance().getConfigDir().resolve("craftui/layouts");
        if (!Files.isDirectory(layoutDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(layoutDir, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(LayoutManager::deleteSneaky);
        }
        catch (IOException e) {
            LOGGER.error("Error deleting user layouts: ", (Throwable)e);
        }
        this.setLayoutUpdate(true);
    }

    private static void deleteSneaky(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    private void loadUserLayouts() {
        this.userLayouts.clear();
        Path rootDir = FabricLoader.getInstance().getConfigDir().resolve("craftui/layouts");
        if (!Files.isDirectory(rootDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(rootDir, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".ini") && Files.isRegularFile(p, new LinkOption[0]));){
            stream.forEach(file -> {
                class_2960 id;
                Path relative = rootDir.relativize((Path)file);
                if (relative.getNameCount() < 2) {
                    LOGGER.warn("Skipping layout file not inside a namespace folder: {}", file);
                    return;
                }
                String namespace = relative.getName(0).toString();
                Path localPath = relative.subpath(1, relative.getNameCount());
                String idPath = FilenameUtils.removeExtension((String)localPath.toString()).replace('\\', '/');
                if (idPath.isEmpty()) {
                    return;
                }
                try {
                    id = class_2960.method_60655((String)namespace, (String)idPath);
                }
                catch (class_151 e) {
                    LOGGER.error(e.getMessage());
                    return;
                }
                try {
                    String contents = Files.readString(file);
                    this.userLayouts.put(id, contents);
                }
                catch (IOException e) {
                    LOGGER.error("Error reading user layout {}: ", file, (Object)e);
                }
            });
            this.setLayoutUpdate(true);
        }
        catch (Exception e) {
            LOGGER.error("Error loading user layouts: ", (Throwable)e);
        }
    }

    private static Path getUserLayoutPath(class_2960 layoutId) {
        return FabricLoader.getInstance().getConfigDir().resolve("craftui/layouts").resolve(layoutId.method_12836()).resolve(layoutId.method_12832() + ".ini");
    }

    private void saveUserLayout(class_2960 layoutId) {
        String contents = this.getUserLayoutData(layoutId);
        if (contents == null || contents.isEmpty()) {
            LOGGER.warn("Unable to save user layout {} because it does not exist.", (Object)layoutId);
            return;
        }
        Path path = LayoutManager.getUserLayoutPath(layoutId);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(contents);
            }
            LOGGER.debug("Saved user layout to {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Error saving user layout {}: ", (Object)layoutId, (Object)e);
        }
    }

    private void loadNativeLayouts(class_3300 manager) {
        this.nativeLayouts.clear();
        for (Map.Entry entry : manager.method_14488("layouts", id -> id.method_12832().endsWith(".ini")).entrySet()) {
            class_2960 filename = (class_2960)entry.getKey();
            String filepath = FilenameUtils.removeExtension((String)filename.method_12832().substring("layouts/".length()));
            class_2960 id2 = class_2960.method_60655((String)filename.method_12836(), (String)filepath);
            LOGGER.debug("Loading IMGUI layout from {} as {}", (Object)filename, (Object)id2);
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    String text = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                    this.nativeLayouts.put(id2, text);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error reading layout {}: ", (Object)id2, (Object)e);
            }
        }
        this.setLayoutUpdate(true);
    }

    public class_2960 getFabricId() {
        return class_2960.method_60654((String)"craftui:layouts");
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor) {
        this.nativeLayouts.clear();
        return ((CompletableFuture)CompletableFuture.runAsync(() -> this.loadNativeLayouts(manager), prepareExecutor).thenRun(this::loadUserLayouts)).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0));
    }

    @NotNull
    @Generated
    public class_2960 getActiveLayout() {
        return this.activeLayout;
    }

    @Generated
    public boolean isLayoutUpdate() {
        return this.layoutUpdate;
    }

    @Generated
    public void setLayoutUpdate(boolean layoutUpdate) {
        this.layoutUpdate = layoutUpdate;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"CraftUI LayoutManager");
    }
}

