/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.impl.style;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igrium.craftui.impl.util.JsonUtils;
import com.igrium.craftui.style.CraftUIStyle;
import com.igrium.craftui.style.CraftUIStyles;
import imgui.ImGuiStyle;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleManager
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CraftUI StyleManager");
    private static final Gson GSON = new GsonBuilder().create();
    private static final CraftUIStyle NATIVE = new CraftUIStyle();
    private static final JsonObject NATIVE_JSON;
    private static StyleManager instance;
    private boolean wantStyleUpdate = true;
    private final Map<class_2960, CraftUIStyle> styles = new HashMap<class_2960, CraftUIStyle>();
    @NonNull
    private class_2960 activeStyle = CraftUIStyles.DARK;

    public static StyleManager getInstance() {
        if (instance == null) {
            instance = new StyleManager();
        }
        return instance;
    }

    private StyleManager() {
    }

    @Nullable
    public CraftUIStyle getStyle(class_2960 id) {
        return this.styles.get(id);
    }

    public Map<class_2960, CraftUIStyle> getStyles() {
        return Collections.unmodifiableMap(this.styles);
    }

    public void setActiveStyle(@NonNull class_2960 activeStyle) {
        if (activeStyle == null) {
            throw new NullPointerException("activeStyle is marked non-null but is null");
        }
        if (activeStyle != this.activeStyle) {
            this.activeStyle = activeStyle;
            this.wantStyleUpdate = true;
        }
    }

    @NonNull
    public CraftUIStyle getActiveStyleData() {
        CraftUIStyle active = this.getStyle(this.getActiveStyle());
        if (active == null) {
            LOGGER.warn("Unknown style: {}", (Object)this.getActiveStyle());
            return NATIVE;
        }
        return active;
    }

    public class_2960 getFabricId() {
        return class_2960.method_60654((String)"craftui:stylemanager");
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ConcurrentHashMap parsedJson = new ConcurrentHashMap();
        for (Map.Entry entry : manager.method_41265("ui/styles", p -> p.toString().endsWith(".json")).entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                JsonObject obj = null;
                for (class_3298 r : (List)entry.getValue()) {
                    try {
                        BufferedReader reader = r.method_43039();
                        try {
                            JsonObject obj2 = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                            if (obj == null) {
                                obj = obj2;
                                continue;
                            }
                            JsonUtils.extendJsonObject(obj, obj2, JsonUtils.ConflictStrategy.PREFER_SECOND);
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error loading style {} from pack {}: ", new Object[]{entry.getKey(), r.method_14480(), e});
                    }
                }
                if (obj != null) {
                    parsedJson.put(this.getStyleId((class_2960)entry.getKey()), obj);
                }
            }, prepareExecutor));
        }
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenRunAsync(() -> {
            this.styles.clear();
            for (Map.Entry entry : parsedJson.entrySet()) {
                try {
                    JsonObject json = (JsonObject)entry.getValue();
                    StyleManager.applyParents(json, parsedJson, new HashSet<class_2960>());
                    this.styles.put((class_2960)entry.getKey(), (CraftUIStyle)GSON.fromJson((JsonElement)json, CraftUIStyle.class));
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing json for style {}: ", entry.getKey(), (Object)e);
                }
            }
            this.setWantStyleUpdate(true);
        }, applyExecutor);
    }

    private class_2960 getStyleId(class_2960 fileId) {
        String path = FilenameUtils.removeExtension((String)fileId.method_12832().substring("ui/styles/".length()));
        return class_2960.method_60655((String)fileId.method_12836(), (String)path);
    }

    private static void applyParents(JsonObject obj, Map<class_2960, JsonObject> allValues, Set<class_2960> usedIdentifiers) {
        if (obj.has("parent")) {
            class_2960 parentName = class_2960.method_60654((String)obj.get("parent").getAsString());
            if (usedIdentifiers.contains(parentName)) {
                throw new IllegalStateException("Circular style dependency: " + String.valueOf(parentName));
            }
            obj.remove("parent");
            JsonObject parent = allValues.get(parentName);
            if (parent == null) {
                LOGGER.warn("Tried to load non-existent parent style: {}", (Object)parentName);
                return;
            }
            usedIdentifiers.add(parentName);
            StyleManager.applyParents(parent, allValues, usedIdentifiers);
            JsonUtils.extendJsonObject(obj, parent, JsonUtils.ConflictStrategy.PREFER_FIRST);
        } else {
            JsonUtils.extendJsonObject(obj, NATIVE_JSON, JsonUtils.ConflictStrategy.PREFER_FIRST);
        }
    }

    @Generated
    public boolean isWantStyleUpdate() {
        return this.wantStyleUpdate;
    }

    @Generated
    public void setWantStyleUpdate(boolean wantStyleUpdate) {
        this.wantStyleUpdate = wantStyleUpdate;
    }

    @NonNull
    @Generated
    public class_2960 getActiveStyle() {
        return this.activeStyle;
    }

    static {
        NATIVE.fromNativeStyle(new ImGuiStyle());
        NATIVE_JSON = GSON.toJsonTree((Object)NATIVE).getAsJsonObject();
    }
}

