/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.impl.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import lombok.Generated;

public final class JsonUtils {
    public static void extendJsonObject(JsonObject dest, JsonObject addend, ConflictStrategy conflictStrategy, ArrayMergeStrategy arrayMergeStrategy) {
        for (Map.Entry entry : addend.entrySet()) {
            JsonElement existing = dest.get((String)entry.getKey());
            if (existing != null) {
                Object v = entry.getValue();
                if (v instanceof JsonArray) {
                    JsonArray arr = (JsonArray)v;
                    if (existing instanceof JsonArray) {
                        JsonArray dArr = (JsonArray)existing;
                        switch (arrayMergeStrategy.ordinal()) {
                            case 0: {
                                if (conflictStrategy != ConflictStrategy.PREFER_SECOND) break;
                                dest.add((String)entry.getKey(), (JsonElement)arr.deepCopy());
                                break;
                            }
                            case 1: {
                                JsonArray arr2 = new JsonArray(dArr.size() + arr.size());
                                arr2.addAll(arr.deepCopy());
                                arr2.addAll(dArr);
                                dest.add((String)entry.getKey(), (JsonElement)arr2);
                                break;
                            }
                            case 2: {
                                dArr.addAll(arr.deepCopy());
                            }
                        }
                        continue;
                    }
                }
                if ((v = entry.getValue()) instanceof JsonObject) {
                    JsonObject obj = (JsonObject)v;
                    if (existing instanceof JsonObject) {
                        JsonObject dObj = (JsonObject)existing;
                        JsonUtils.extendJsonObject(dObj, obj, conflictStrategy, arrayMergeStrategy);
                        continue;
                    }
                }
                switch (conflictStrategy.ordinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        dest.add((String)entry.getKey(), (JsonElement)entry.getValue());
                        break;
                    }
                    case 2: {
                        if (!existing.isJsonNull()) break;
                        dest.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                }
                continue;
            }
            dest.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public static void extendJsonObject(JsonObject dest, JsonObject addend, ConflictStrategy conflictStrategy) {
        JsonUtils.extendJsonObject(dest, addend, conflictStrategy, ArrayMergeStrategy.REPLACE);
    }

    @Generated
    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum ArrayMergeStrategy {
        REPLACE,
        PREPEND,
        APPEND;

    }

    public static enum ConflictStrategy {
        PREFER_FIRST,
        PREFER_SECOND,
        PREFER_NON_NULL;

    }
}

