/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.impl.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.igrium.craftui.icon.NbtIcons;
import imgui.ImGui;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NbtEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NbtEditor.class);
    public static final int READONLY = 1;
    public static final int NO_RENAME = 2;
    private static final Map<Integer, ImString> renamingElements = new HashMap<Integer, ImString>();
    private static final Set<Integer> renameInit = new HashSet<Integer>();

    public static boolean drawNbtEditor(@NonNull String name, @NonNull class_2520 nbt, int flags) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        return NbtEditor.drawNbtEditor(name, nbt, n -> System.out.println("Renamed to " + n), e -> {}, flags);
    }

    private static <T extends class_2520> boolean drawNbtEditor(String name, T nbt, Consumer<String> renameCallback, Consumer<T> updateCallback, int flags) {
        if (nbt instanceof class_2487) {
            class_2487 compound = (class_2487)nbt;
            return NbtEditor.drawCompoundEditor(name, compound, renameCallback, flags);
        }
        if (nbt instanceof class_2519) {
            class_2519 strNbt = (class_2519)nbt;
            return NbtEditor.drawStringEditor(name, strNbt, renameCallback, updateCallback, flags);
        }
        if (nbt instanceof class_2481) {
            class_2481 byteNbt = (class_2481)nbt;
            return NbtEditor.drawByteEditor(name, byteNbt, renameCallback, updateCallback, flags);
        }
        if (nbt instanceof class_2516) {
            class_2516 shortNbt = (class_2516)nbt;
            return NbtEditor.drawShortEditor(name, shortNbt, renameCallback, updateCallback, flags);
        }
        if (nbt instanceof class_2497) {
            class_2497 intNbt = (class_2497)nbt;
            return NbtEditor.drawIntEditor(name, intNbt, renameCallback, updateCallback, flags);
        }
        if (nbt instanceof class_2503) {
            class_2503 longNbt = (class_2503)nbt;
            return NbtEditor.drawLongEditor(name, longNbt, renameCallback, updateCallback, flags);
        }
        if (nbt instanceof class_2494) {
            class_2494 floatNbt = (class_2494)nbt;
            return NbtEditor.drawFloatEditor(name, floatNbt, renameCallback, updateCallback, flags);
        }
        if (nbt instanceof class_2489) {
            class_2489 doubleNbt = (class_2489)nbt;
            return NbtEditor.drawDoubleEditor(name, doubleNbt, renameCallback, updateCallback, flags);
        }
        return NbtEditor.drawUnknown(name, nbt, renameCallback, flags);
    }

    private static boolean drawCompoundEditor(String name, class_2487 compound, Consumer<String> renameCallback, int flags) {
        ImGui.alignTextToFramePadding();
        boolean open = ImGui.treeNodeEx((String)("##" + name));
        ImGui.sameLine();
        NbtIcons.drawIcon((byte)10);
        ImGui.sameLine();
        if (!NbtEditor.renamableLabel(name, renameCallback, flags)) {
            ImGui.sameLine();
            ImGui.text((String)("(" + compound.method_10546() + " items)"));
        }
        HashBiMap renames = HashBiMap.create();
        MutableBoolean updated = new MutableBoolean();
        if (open) {
            ArrayList keyList = new ArrayList(compound.method_10541());
            keyList.sort(String.CASE_INSENSITIVE_ORDER);
            for (String key : keyList) {
                class_2520 value;
                if (!NbtEditor.drawNbtEditor(key, value = compound.method_10580(key), arg_0 -> NbtEditor.lambda$drawCompoundEditor$3(key, compound, (BiMap)renames, updated, arg_0), newVal -> {
                    compound.method_10566(key, newVal);
                    updated.setTrue();
                }, flags &= 0xFFFFFFFD)) continue;
                updated.setTrue();
            }
            ImGui.treePop();
        }
        for (Map.Entry entry : renames.entrySet()) {
            class_2520 value = compound.method_10580((String)entry.getKey());
            compound.method_10551((String)entry.getKey());
            compound.method_10566((String)entry.getValue(), value);
        }
        return updated.booleanValue();
    }

    private static boolean drawStringEditor(String name, class_2519 nbt, Consumer<String> renameCallback, Consumer<class_2519> updateCallback, int flags) {
        return NbtEditor.drawPrimitiveEditor(name, nbt, nbt.method_10714(), renameCallback, str -> updateCallback.accept(class_2519.method_23256((String)str)), flags);
    }

    private static boolean drawByteEditor(String name, class_2481 nbt, Consumer<String> renameCallback, Consumer<class_2481> updateCallback, int flags) {
        return NbtEditor.drawPrimitiveEditor(name, nbt, Byte.toString(nbt.method_10698()), renameCallback, str -> updateCallback.accept(class_2481.method_23233((byte)Byte.parseByte(str))), flags);
    }

    private static boolean drawShortEditor(String name, class_2516 nbt, Consumer<String> renameCallback, Consumer<class_2516> updateCallback, int flags) {
        return NbtEditor.drawPrimitiveEditor(name, nbt, Short.toString(nbt.method_10696()), renameCallback, str -> updateCallback.accept(class_2516.method_23254((short)Short.parseShort(str))), flags);
    }

    private static boolean drawIntEditor(String name, class_2497 nbt, Consumer<String> renameCallback, Consumer<class_2497> updateCallback, int flags) {
        return NbtEditor.drawPrimitiveEditor(name, nbt, Integer.toString(nbt.method_10701()), renameCallback, str -> updateCallback.accept(class_2497.method_23247((int)Integer.parseInt(str))), flags);
    }

    private static boolean drawLongEditor(String name, class_2503 nbt, Consumer<String> renameCallback, Consumer<class_2503> updateCallback, int flags) {
        return NbtEditor.drawPrimitiveEditor(name, nbt, Long.toString(nbt.method_10699()), renameCallback, str -> updateCallback.accept(class_2503.method_23251((long)Long.parseLong(str))), flags);
    }

    private static boolean drawFloatEditor(String name, class_2494 nbt, Consumer<String> renameCallback, Consumer<class_2494> updateCallback, int flags) {
        return NbtEditor.drawPrimitiveEditor(name, nbt, Float.toString(nbt.method_10700()), renameCallback, str -> updateCallback.accept(class_2494.method_23244((float)Float.parseFloat(str))), flags);
    }

    private static boolean drawDoubleEditor(String name, class_2489 nbt, Consumer<String> renameCallback, Consumer<class_2489> updateCallback, int flags) {
        return NbtEditor.drawPrimitiveEditor(name, nbt, Double.toString(nbt.method_10697()), renameCallback, str -> updateCallback.accept(class_2489.method_23241((double)Double.parseDouble(str))), flags);
    }

    private static <T extends class_2520> boolean drawPrimitiveEditor(String name, T element, String elementStringValue, Consumer<String> renameCallback, Consumer<String> updateCallback, int flags) {
        MutableBoolean updated = new MutableBoolean();
        ImGui.alignTextToFramePadding();
        boolean open = ImGui.treeNodeEx((String)("##name" + name), (int)256);
        ImGui.sameLine();
        NbtIcons.drawIcon(element.method_10711());
        ImGui.sameLine((float)0.0f, (float)4.0f);
        NbtEditor.renamableLabel(name + "##name", str -> {
            updated.setTrue();
            renameCallback.accept((String)str);
        }, flags);
        ImGui.sameLine();
        ImGui.text((String)":");
        ImGui.sameLine();
        NbtEditor.renamableLabel(elementStringValue + "##value", str -> {
            updated.setTrue();
            try {
                updateCallback.accept((String)str);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid value for NBT number: {}", str);
            }
        }, flags & 0xFFFFFFFD);
        if (open) {
            ImGui.treePop();
        }
        return updated.booleanValue();
    }

    private static boolean drawUnknown(String name, class_2520 element, Consumer<String> renameCallback, int flags) {
        ImGui.alignTextToFramePadding();
        boolean open = ImGui.treeNodeEx((String)("##" + name), (int)256);
        ImGui.sameLine();
        NbtIcons.drawIcon(element.method_10711());
        MutableBoolean updated = new MutableBoolean();
        ImGui.sameLine();
        NbtEditor.renamableLabel(name, str -> {
            updated.setTrue();
            renameCallback.accept((String)str);
        }, flags);
        ImGui.sameLine();
        ImGui.text((String)" [NBT type not supported]");
        if (open) {
            ImGui.treePop();
        }
        return updated.booleanValue();
    }

    private static boolean renamableLabel(String name, Consumer<String> renameCallback, int flags) {
        boolean isReadonly = (flags & 1) == 1;
        boolean noRename = isReadonly || (flags & 2) == 2;
        int id = ImGui.getID((String)name);
        ImString renameStr = renamingElements.get(id);
        if (renameStr != null) {
            if (ImGui.inputText((String)"##label", (ImString)renameStr, (int)32)) {
                renamingElements.remove(id);
                renameInit.remove(id);
                renameCallback.accept(renameStr.get());
            } else if (renameInit.remove(id)) {
                ImGui.setKeyboardFocusHere((int)-1);
            } else if (!ImGui.isItemActive()) {
                renamingElements.remove(id);
            }
            return true;
        }
        float labelWidth = ImGui.calcTextSize((String)NbtEditor.getRenderedText((String)name)).x;
        ImGui.selectable((String)name, (boolean)false, (int)4, (float)labelWidth, (float)0.0f);
        if (ImGui.isItemHovered() && ImGui.isMouseDoubleClicked((int)0) && !noRename) {
            ImString str = new ImString();
            str.set(NbtEditor.getRenderedText(name));
            renamingElements.put(id, str);
            renameInit.add(id);
        }
        return false;
    }

    private static int findRenderedTextEnd(String text) {
        int hashPos = text.indexOf("##");
        return hashPos >= 0 ? hashPos : text.length();
    }

    private static String getRenderedText(String text) {
        return text.substring(0, NbtEditor.findRenderedTextEnd(text));
    }

    private static String ensureNoDuplicates(String str, Predicate<String> contains) {
        int number = 0;
        Object result = str;
        while (contains.test((String)result)) {
            result = str + "." + ++number;
        }
        return result;
    }

    @Generated
    private NbtEditor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$drawCompoundEditor$3(String key, class_2487 compound, BiMap renames, MutableBoolean updated, String newName) {
        if (newName.equals(key)) {
            return;
        }
        newName = NbtEditor.ensureNoDuplicates(newName, n -> compound.method_10545(n) || renames.containsValue(n));
        renames.put((Object)key, (Object)newName);
        updated.setTrue();
    }
}

