/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.style;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import imgui.ImColor;
import imgui.ImGuiStyle;
import imgui.ImVec4;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public final class CraftUIColors {
    public static final BiMap<String, Integer> COLOR_NAMES = HashBiMap.create();

    public static void buildStyle(ImGuiStyle style, Map<? extends String, ? extends UIColor> colors) {
        for (Map.Entry<? extends String, ? extends UIColor> entry : colors.entrySet()) {
            int color = entry.getValue().color();
            Integer colorId = (Integer)COLOR_NAMES.get((Object)entry.getKey());
            if (colorId == null) {
                LoggerFactory.getLogger(CraftUIColors.class).warn("Unknown IMGUI color: " + entry.getKey());
                continue;
            }
            style.setColor(colorId.intValue(), color);
        }
    }

    public static Map<String, UIColor> fromStyle(ImGuiStyle style) {
        ImVec4 col = new ImVec4();
        HashMap<String, UIColor> colors = new HashMap<String, UIColor>();
        for (Map.Entry entry : COLOR_NAMES.entrySet()) {
            style.getColor(((Integer)entry.getValue()).intValue(), col);
            colors.put((String)entry.getKey(), new UIColor(ImColor.rgba((ImVec4)col), null));
        }
        return colors;
    }

    private static int readColor(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case NUMBER: {
                return reader.nextInt();
            }
            case BEGIN_ARRAY: {
                int i;
                float[] vals = new float[4];
                reader.beginArray();
                for (i = 0; reader.peek() != JsonToken.END_ARRAY && i < 4; ++i) {
                    vals[i] = (float)reader.nextDouble();
                }
                reader.endArray();
                if (i < 4) {
                    vals[3] = 1.0f;
                }
                return ImColor.rgba((float)vals[0], (float)vals[1], (float)vals[2], (float)vals[3]);
            }
        }
        throw new JsonParseException("Invalid json token type for color.");
    }

    @Generated
    private CraftUIColors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        COLOR_NAMES.put((Object)"text", (Object)0);
        COLOR_NAMES.put((Object)"textDisabled", (Object)1);
        COLOR_NAMES.put((Object)"windowBg", (Object)2);
        COLOR_NAMES.put((Object)"childBg", (Object)3);
        COLOR_NAMES.put((Object)"popupBg", (Object)4);
        COLOR_NAMES.put((Object)"border", (Object)5);
        COLOR_NAMES.put((Object)"borderShadow", (Object)6);
        COLOR_NAMES.put((Object)"frameBg", (Object)7);
        COLOR_NAMES.put((Object)"frameBgHovered", (Object)8);
        COLOR_NAMES.put((Object)"frameBgActive", (Object)9);
        COLOR_NAMES.put((Object)"titleBg", (Object)10);
        COLOR_NAMES.put((Object)"titleBgActive", (Object)11);
        COLOR_NAMES.put((Object)"titleBgCollapsed", (Object)12);
        COLOR_NAMES.put((Object)"menuBarBg", (Object)13);
        COLOR_NAMES.put((Object)"scrollbarBg", (Object)14);
        COLOR_NAMES.put((Object)"scrollbarGrab", (Object)15);
        COLOR_NAMES.put((Object)"scrollbarGrabHovered", (Object)16);
        COLOR_NAMES.put((Object)"scrollbarGrabActive", (Object)17);
        COLOR_NAMES.put((Object)"checkMark", (Object)18);
        COLOR_NAMES.put((Object)"sliderGrab", (Object)19);
        COLOR_NAMES.put((Object)"sliderGrabActive", (Object)20);
        COLOR_NAMES.put((Object)"button", (Object)21);
        COLOR_NAMES.put((Object)"buttonHovered", (Object)22);
        COLOR_NAMES.put((Object)"buttonActive", (Object)23);
        COLOR_NAMES.put((Object)"header", (Object)24);
        COLOR_NAMES.put((Object)"headerHovered", (Object)25);
        COLOR_NAMES.put((Object)"headerActive", (Object)26);
        COLOR_NAMES.put((Object)"separator", (Object)27);
        COLOR_NAMES.put((Object)"separatorHovered", (Object)28);
        COLOR_NAMES.put((Object)"separatorActive", (Object)29);
        COLOR_NAMES.put((Object)"resizeGrip", (Object)30);
        COLOR_NAMES.put((Object)"resizeGripHovered", (Object)31);
        COLOR_NAMES.put((Object)"resizeGripActive", (Object)32);
        COLOR_NAMES.put((Object)"tab", (Object)33);
        COLOR_NAMES.put((Object)"tabHovered", (Object)34);
        COLOR_NAMES.put((Object)"tabActive", (Object)35);
        COLOR_NAMES.put((Object)"tabUnfocused", (Object)36);
        COLOR_NAMES.put((Object)"tabUnfocusedActive", (Object)37);
        COLOR_NAMES.put((Object)"dockingPreview", (Object)38);
        COLOR_NAMES.put((Object)"dockingEmptyBg", (Object)39);
        COLOR_NAMES.put((Object)"plotLines", (Object)40);
        COLOR_NAMES.put((Object)"plotLinesHovered", (Object)41);
        COLOR_NAMES.put((Object)"plotHistogram", (Object)42);
        COLOR_NAMES.put((Object)"plotHistogramHovered", (Object)43);
        COLOR_NAMES.put((Object)"tableHeaderBg", (Object)44);
        COLOR_NAMES.put((Object)"tableBorderStrong", (Object)45);
        COLOR_NAMES.put((Object)"tableBorderLight", (Object)46);
        COLOR_NAMES.put((Object)"tableRowBg", (Object)47);
        COLOR_NAMES.put((Object)"tableRowBgAlt", (Object)48);
        COLOR_NAMES.put((Object)"textSelectedBg", (Object)49);
        COLOR_NAMES.put((Object)"dragDropTarget", (Object)50);
        COLOR_NAMES.put((Object)"navHighlight", (Object)51);
        COLOR_NAMES.put((Object)"navWindowingHighlight", (Object)52);
        COLOR_NAMES.put((Object)"navWindowingDimBg", (Object)53);
        COLOR_NAMES.put((Object)"modalWindowDimBg", (Object)54);
    }

    @JsonAdapter(value=UIColorJsonAdapter.class)
    public record UIColor(int color, @Nullable String ref) {
        static final UIColor BLACK = new UIColor(0, null);

        int get(Map<String, UIColor> defs) {
            UIColor r2;
            if (this.ref != null && (r2 = defs.get(this.ref)) != null) {
                return r2.color;
            }
            return this.color;
        }
    }

    private static class UIColorJsonAdapter
    extends TypeAdapter<UIColor> {
        private UIColorJsonAdapter() {
        }

        public void write(JsonWriter out, UIColor value) throws IOException {
            if (value.ref() != null) {
                out.value(value.ref());
            } else {
                String str = Integer.toHexString(Integer.reverseBytes(value.color));
                out.value("#" + str);
            }
        }

        public UIColor read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.STRING) {
                Object str = in.nextString();
                if (((String)str).startsWith("#")) {
                    if (((String)str).length() == 7) {
                        str = (String)str + "FF";
                    }
                    int val = Integer.reverseBytes(Integer.parseUnsignedInt(((String)str).substring(1), 16));
                    return new UIColor(val, null);
                }
                return new UIColor(0, (String)str);
            }
            return new UIColor(CraftUIColors.readColor(in), null);
        }
    }
}

